/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLimitsResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, DescribeLimitsResponse> {
    private final Integer shardLimit;
    private final Integer openShardCount;

    private DescribeLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.shardLimit = builder.shardLimit;
        this.openShardCount = builder.openShardCount;
    }

    public Integer shardLimit() {
        return this.shardLimit;
    }

    public Integer openShardCount() {
        return this.openShardCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shardLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.openShardCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLimitsResponse)) {
            return false;
        }
        DescribeLimitsResponse other = (DescribeLimitsResponse)((Object)obj);
        return Objects.equals(this.shardLimit(), other.shardLimit()) && Objects.equals(this.openShardCount(), other.openShardCount());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLimitsResponse").add("ShardLimit", (Object)this.shardLimit()).add("OpenShardCount", (Object)this.openShardCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShardLimit": {
                return Optional.of(clazz.cast(this.shardLimit()));
            }
            case "OpenShardCount": {
                return Optional.of(clazz.cast(this.openShardCount()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private Integer shardLimit;
        private Integer openShardCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLimitsResponse model) {
            this.shardLimit(model.shardLimit);
            this.openShardCount(model.openShardCount);
        }

        public final Integer getShardLimit() {
            return this.shardLimit;
        }

        @Override
        public final Builder shardLimit(Integer shardLimit) {
            this.shardLimit = shardLimit;
            return this;
        }

        public final void setShardLimit(Integer shardLimit) {
            this.shardLimit = shardLimit;
        }

        public final Integer getOpenShardCount() {
            return this.openShardCount;
        }

        @Override
        public final Builder openShardCount(Integer openShardCount) {
            this.openShardCount = openShardCount;
            return this;
        }

        public final void setOpenShardCount(Integer openShardCount) {
            this.openShardCount = openShardCount;
        }

        @Override
        public DescribeLimitsResponse build() {
            return new DescribeLimitsResponse(this);
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    CopyableBuilder<Builder, DescribeLimitsResponse> {
        public Builder shardLimit(Integer var1);

        public Builder openShardCount(Integer var1);
    }
}

