/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.firehose.model.Processor;
import software.amazon.awssdk.services.firehose.transform.ProcessorParameterUnmarshaller;

public class ProcessorUnmarshaller
implements Unmarshaller<Processor, JsonUnmarshallerContext> {
    private static final ProcessorUnmarshaller INSTANCE = new ProcessorUnmarshaller();

    public Processor unmarshall(JsonUnmarshallerContext context) throws Exception {
        Processor.Builder processorBuilder = Processor.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    processorBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    processorBuilder.parameters(new ListUnmarshaller((Unmarshaller)ProcessorParameterUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Processor)processorBuilder.build();
    }

    public static ProcessorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

