/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.KMSEncryptionConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KMSEncryptionConfigMarshaller {
    private static final MarshallingInfo<String> AWSKMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AWSKMSKeyARN").isBinary(false).build();
    private static final KMSEncryptionConfigMarshaller INSTANCE = new KMSEncryptionConfigMarshaller();

    private KMSEncryptionConfigMarshaller() {
    }

    public static KMSEncryptionConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KMSEncryptionConfig kmsEncryptionConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)kmsEncryptionConfig, (String)"kmsEncryptionConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)kmsEncryptionConfig.awskmsKeyARN(), AWSKMSKEYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

