/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.CopyCommand;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.RedshiftRetryOptions;
import software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode;
import software.amazon.awssdk.services.firehose.model.S3DestinationUpdate;
import software.amazon.awssdk.services.firehose.transform.RedshiftDestinationUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RedshiftDestinationUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, RedshiftDestinationUpdate> {
    private final String roleARN;
    private final String clusterJDBCURL;
    private final CopyCommand copyCommand;
    private final String username;
    private final String password;
    private final RedshiftRetryOptions retryOptions;
    private final S3DestinationUpdate s3Update;
    private final ProcessingConfiguration processingConfiguration;
    private final String s3BackupMode;
    private final S3DestinationUpdate s3BackupUpdate;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private RedshiftDestinationUpdate(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.clusterJDBCURL = builder.clusterJDBCURL;
        this.copyCommand = builder.copyCommand;
        this.username = builder.username;
        this.password = builder.password;
        this.retryOptions = builder.retryOptions;
        this.s3Update = builder.s3Update;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3BackupUpdate = builder.s3BackupUpdate;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String clusterJDBCURL() {
        return this.clusterJDBCURL;
    }

    public CopyCommand copyCommand() {
        return this.copyCommand;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public RedshiftRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public S3DestinationUpdate s3Update() {
        return this.s3Update;
    }

    public ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public RedshiftS3BackupMode s3BackupMode() {
        return RedshiftS3BackupMode.fromValue(this.s3BackupMode);
    }

    public String s3BackupModeString() {
        return this.s3BackupMode;
    }

    public S3DestinationUpdate s3BackupUpdate() {
        return this.s3BackupUpdate;
    }

    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterJDBCURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyCommand());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Update());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDestinationUpdate)) {
            return false;
        }
        RedshiftDestinationUpdate other = (RedshiftDestinationUpdate)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.clusterJDBCURL(), other.clusterJDBCURL()) && Objects.equals(this.copyCommand(), other.copyCommand()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3Update(), other.s3Update()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.s3BackupModeString(), other.s3BackupModeString()) && Objects.equals(this.s3BackupUpdate(), other.s3BackupUpdate()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions());
    }

    public String toString() {
        return ToString.builder((String)"RedshiftDestinationUpdate").add("RoleARN", (Object)this.roleARN()).add("ClusterJDBCURL", (Object)this.clusterJDBCURL()).add("CopyCommand", (Object)this.copyCommand()).add("Username", (Object)this.username()).add("Password", (Object)this.password()).add("RetryOptions", (Object)this.retryOptions()).add("S3Update", (Object)this.s3Update()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("S3BackupMode", (Object)this.s3BackupModeString()).add("S3BackupUpdate", (Object)this.s3BackupUpdate()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "ClusterJDBCURL": {
                return Optional.of(clazz.cast(this.clusterJDBCURL()));
            }
            case "CopyCommand": {
                return Optional.of(clazz.cast(this.copyCommand()));
            }
            case "Username": {
                return Optional.of(clazz.cast(this.username()));
            }
            case "Password": {
                return Optional.of(clazz.cast(this.password()));
            }
            case "RetryOptions": {
                return Optional.of(clazz.cast(this.retryOptions()));
            }
            case "S3Update": {
                return Optional.of(clazz.cast(this.s3Update()));
            }
            case "ProcessingConfiguration": {
                return Optional.of(clazz.cast(this.processingConfiguration()));
            }
            case "S3BackupMode": {
                return Optional.of(clazz.cast(this.s3BackupModeString()));
            }
            case "S3BackupUpdate": {
                return Optional.of(clazz.cast(this.s3BackupUpdate()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.of(clazz.cast(this.cloudWatchLoggingOptions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftDestinationUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String clusterJDBCURL;
        private CopyCommand copyCommand;
        private String username;
        private String password;
        private RedshiftRetryOptions retryOptions;
        private S3DestinationUpdate s3Update;
        private ProcessingConfiguration processingConfiguration;
        private String s3BackupMode;
        private S3DestinationUpdate s3BackupUpdate;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDestinationUpdate model) {
            this.roleARN(model.roleARN);
            this.clusterJDBCURL(model.clusterJDBCURL);
            this.copyCommand(model.copyCommand);
            this.username(model.username);
            this.password(model.password);
            this.retryOptions(model.retryOptions);
            this.s3Update(model.s3Update);
            this.processingConfiguration(model.processingConfiguration);
            this.s3BackupMode(model.s3BackupMode);
            this.s3BackupUpdate(model.s3BackupUpdate);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getClusterJDBCURL() {
            return this.clusterJDBCURL;
        }

        @Override
        public final Builder clusterJDBCURL(String clusterJDBCURL) {
            this.clusterJDBCURL = clusterJDBCURL;
            return this;
        }

        public final void setClusterJDBCURL(String clusterJDBCURL) {
            this.clusterJDBCURL = clusterJDBCURL;
        }

        public final CopyCommand.Builder getCopyCommand() {
            return this.copyCommand != null ? this.copyCommand.toBuilder() : null;
        }

        @Override
        public final Builder copyCommand(CopyCommand copyCommand) {
            this.copyCommand = copyCommand;
            return this;
        }

        public final void setCopyCommand(CopyCommand.BuilderImpl copyCommand) {
            this.copyCommand = copyCommand != null ? copyCommand.build() : null;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final RedshiftRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        @Override
        public final Builder retryOptions(RedshiftRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(RedshiftRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        public final S3DestinationUpdate.Builder getS3Update() {
            return this.s3Update != null ? this.s3Update.toBuilder() : null;
        }

        @Override
        public final Builder s3Update(S3DestinationUpdate s3Update) {
            this.s3Update = s3Update;
            return this;
        }

        public final void setS3Update(S3DestinationUpdate.BuilderImpl s3Update) {
            this.s3Update = s3Update != null ? s3Update.build() : null;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(RedshiftS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationUpdate.Builder getS3BackupUpdate() {
            return this.s3BackupUpdate != null ? this.s3BackupUpdate.toBuilder() : null;
        }

        @Override
        public final Builder s3BackupUpdate(S3DestinationUpdate s3BackupUpdate) {
            this.s3BackupUpdate = s3BackupUpdate;
            return this;
        }

        public final void setS3BackupUpdate(S3DestinationUpdate.BuilderImpl s3BackupUpdate) {
            this.s3BackupUpdate = s3BackupUpdate != null ? s3BackupUpdate.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        public RedshiftDestinationUpdate build() {
            return new RedshiftDestinationUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RedshiftDestinationUpdate> {
        public Builder roleARN(String var1);

        public Builder clusterJDBCURL(String var1);

        public Builder copyCommand(CopyCommand var1);

        default public Builder copyCommand(Consumer<CopyCommand.Builder> copyCommand) {
            return this.copyCommand((CopyCommand)((CopyCommand.Builder)CopyCommand.builder().apply(copyCommand)).build());
        }

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder retryOptions(RedshiftRetryOptions var1);

        default public Builder retryOptions(Consumer<RedshiftRetryOptions.Builder> retryOptions) {
            return this.retryOptions((RedshiftRetryOptions)((RedshiftRetryOptions.Builder)RedshiftRetryOptions.builder().apply(retryOptions)).build());
        }

        public Builder s3Update(S3DestinationUpdate var1);

        default public Builder s3Update(Consumer<S3DestinationUpdate.Builder> s3Update) {
            return this.s3Update((S3DestinationUpdate)((S3DestinationUpdate.Builder)S3DestinationUpdate.builder().apply(s3Update)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().apply(processingConfiguration)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(RedshiftS3BackupMode var1);

        public Builder s3BackupUpdate(S3DestinationUpdate var1);

        default public Builder s3BackupUpdate(Consumer<S3DestinationUpdate.Builder> s3BackupUpdate) {
            return this.s3BackupUpdate((S3DestinationUpdate)((S3DestinationUpdate.Builder)S3DestinationUpdate.builder().apply(s3BackupUpdate)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().apply(cloudWatchLoggingOptions)).build());
        }
    }
}

