/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamNameListCopier;
import software.amazon.awssdk.services.firehose.model.FirehoseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeliveryStreamsResponse
extends FirehoseResponse
implements ToCopyableBuilder<Builder, ListDeliveryStreamsResponse> {
    private final List<String> deliveryStreamNames;
    private final Boolean hasMoreDeliveryStreams;

    private ListDeliveryStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamNames = builder.deliveryStreamNames;
        this.hasMoreDeliveryStreams = builder.hasMoreDeliveryStreams;
    }

    public List<String> deliveryStreamNames() {
        return this.deliveryStreamNames;
    }

    public Boolean hasMoreDeliveryStreams() {
        return this.hasMoreDeliveryStreams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreDeliveryStreams());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeliveryStreamsResponse)) {
            return false;
        }
        ListDeliveryStreamsResponse other = (ListDeliveryStreamsResponse)((Object)obj);
        return Objects.equals(this.deliveryStreamNames(), other.deliveryStreamNames()) && Objects.equals(this.hasMoreDeliveryStreams(), other.hasMoreDeliveryStreams());
    }

    public String toString() {
        return ToString.builder((String)"ListDeliveryStreamsResponse").add("DeliveryStreamNames", this.deliveryStreamNames()).add("HasMoreDeliveryStreams", (Object)this.hasMoreDeliveryStreams()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamNames": {
                return Optional.of(clazz.cast(this.deliveryStreamNames()));
            }
            case "HasMoreDeliveryStreams": {
                return Optional.of(clazz.cast(this.hasMoreDeliveryStreams()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends FirehoseResponse.BuilderImpl
    implements Builder {
        private List<String> deliveryStreamNames;
        private Boolean hasMoreDeliveryStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeliveryStreamsResponse model) {
            this.deliveryStreamNames(model.deliveryStreamNames);
            this.hasMoreDeliveryStreams(model.hasMoreDeliveryStreams);
        }

        public final Collection<String> getDeliveryStreamNames() {
            return this.deliveryStreamNames;
        }

        @Override
        public final Builder deliveryStreamNames(Collection<String> deliveryStreamNames) {
            this.deliveryStreamNames = DeliveryStreamNameListCopier.copy(deliveryStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryStreamNames(String ... deliveryStreamNames) {
            this.deliveryStreamNames(Arrays.asList(deliveryStreamNames));
            return this;
        }

        public final void setDeliveryStreamNames(Collection<String> deliveryStreamNames) {
            this.deliveryStreamNames = DeliveryStreamNameListCopier.copy(deliveryStreamNames);
        }

        public final Boolean getHasMoreDeliveryStreams() {
            return this.hasMoreDeliveryStreams;
        }

        @Override
        public final Builder hasMoreDeliveryStreams(Boolean hasMoreDeliveryStreams) {
            this.hasMoreDeliveryStreams = hasMoreDeliveryStreams;
            return this;
        }

        public final void setHasMoreDeliveryStreams(Boolean hasMoreDeliveryStreams) {
            this.hasMoreDeliveryStreams = hasMoreDeliveryStreams;
        }

        @Override
        public ListDeliveryStreamsResponse build() {
            return new ListDeliveryStreamsResponse(this);
        }
    }

    public static interface Builder
    extends FirehoseResponse.Builder,
    CopyableBuilder<Builder, ListDeliveryStreamsResponse> {
        public Builder deliveryStreamNames(Collection<String> var1);

        public Builder deliveryStreamNames(String ... var1);

        public Builder hasMoreDeliveryStreams(Boolean var1);
    }
}

