/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamType;
import software.amazon.awssdk.services.firehose.model.FirehoseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeliveryStreamsRequest
extends FirehoseRequest
implements ToCopyableBuilder<Builder, ListDeliveryStreamsRequest> {
    private final Integer limit;
    private final String deliveryStreamType;
    private final String exclusiveStartDeliveryStreamName;

    private ListDeliveryStreamsRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.deliveryStreamType = builder.deliveryStreamType;
        this.exclusiveStartDeliveryStreamName = builder.exclusiveStartDeliveryStreamName;
    }

    public Integer limit() {
        return this.limit;
    }

    public DeliveryStreamType deliveryStreamType() {
        return DeliveryStreamType.fromValue(this.deliveryStreamType);
    }

    public String deliveryStreamTypeString() {
        return this.deliveryStreamType;
    }

    public String exclusiveStartDeliveryStreamName() {
        return this.exclusiveStartDeliveryStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartDeliveryStreamName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeliveryStreamsRequest)) {
            return false;
        }
        ListDeliveryStreamsRequest other = (ListDeliveryStreamsRequest)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.deliveryStreamTypeString(), other.deliveryStreamTypeString()) && Objects.equals(this.exclusiveStartDeliveryStreamName(), other.exclusiveStartDeliveryStreamName());
    }

    public String toString() {
        return ToString.builder((String)"ListDeliveryStreamsRequest").add("Limit", (Object)this.limit()).add("DeliveryStreamType", (Object)this.deliveryStreamTypeString()).add("ExclusiveStartDeliveryStreamName", (Object)this.exclusiveStartDeliveryStreamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "DeliveryStreamType": {
                return Optional.of(clazz.cast(this.deliveryStreamTypeString()));
            }
            case "ExclusiveStartDeliveryStreamName": {
                return Optional.of(clazz.cast(this.exclusiveStartDeliveryStreamName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends FirehoseRequest.BuilderImpl
    implements Builder {
        private Integer limit;
        private String deliveryStreamType;
        private String exclusiveStartDeliveryStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeliveryStreamsRequest model) {
            this.limit(model.limit);
            this.deliveryStreamType(model.deliveryStreamType);
            this.exclusiveStartDeliveryStreamName(model.exclusiveStartDeliveryStreamName);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getDeliveryStreamType() {
            return this.deliveryStreamType;
        }

        @Override
        public final Builder deliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
            return this;
        }

        @Override
        public final Builder deliveryStreamType(DeliveryStreamType deliveryStreamType) {
            this.deliveryStreamType(deliveryStreamType.toString());
            return this;
        }

        public final void setDeliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
        }

        public final String getExclusiveStartDeliveryStreamName() {
            return this.exclusiveStartDeliveryStreamName;
        }

        @Override
        public final Builder exclusiveStartDeliveryStreamName(String exclusiveStartDeliveryStreamName) {
            this.exclusiveStartDeliveryStreamName = exclusiveStartDeliveryStreamName;
            return this;
        }

        public final void setExclusiveStartDeliveryStreamName(String exclusiveStartDeliveryStreamName) {
            this.exclusiveStartDeliveryStreamName = exclusiveStartDeliveryStreamName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListDeliveryStreamsRequest build() {
            return new ListDeliveryStreamsRequest(this);
        }
    }

    public static interface Builder
    extends FirehoseRequest.Builder,
    CopyableBuilder<Builder, ListDeliveryStreamsRequest> {
        public Builder limit(Integer var1);

        public Builder deliveryStreamType(String var1);

        public Builder deliveryStreamType(DeliveryStreamType var1);

        public Builder exclusiveStartDeliveryStreamName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

