/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.KinesisStreamSourceDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KinesisStreamSourceDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, KinesisStreamSourceDescription> {
    private final String kinesisStreamARN;
    private final String roleARN;
    private final Instant deliveryStartTimestamp;

    private KinesisStreamSourceDescription(BuilderImpl builder) {
        this.kinesisStreamARN = builder.kinesisStreamARN;
        this.roleARN = builder.roleARN;
        this.deliveryStartTimestamp = builder.deliveryStartTimestamp;
    }

    public String kinesisStreamARN() {
        return this.kinesisStreamARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Instant deliveryStartTimestamp() {
        return this.deliveryStartTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStartTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamSourceDescription)) {
            return false;
        }
        KinesisStreamSourceDescription other = (KinesisStreamSourceDescription)obj;
        return Objects.equals(this.kinesisStreamARN(), other.kinesisStreamARN()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.deliveryStartTimestamp(), other.deliveryStartTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"KinesisStreamSourceDescription").add("KinesisStreamARN", (Object)this.kinesisStreamARN()).add("RoleARN", (Object)this.roleARN()).add("DeliveryStartTimestamp", (Object)this.deliveryStartTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KinesisStreamARN": {
                return Optional.of(clazz.cast(this.kinesisStreamARN()));
            }
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "DeliveryStartTimestamp": {
                return Optional.of(clazz.cast(this.deliveryStartTimestamp()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisStreamSourceDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String kinesisStreamARN;
        private String roleARN;
        private Instant deliveryStartTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamSourceDescription model) {
            this.kinesisStreamARN(model.kinesisStreamARN);
            this.roleARN(model.roleARN);
            this.deliveryStartTimestamp(model.deliveryStartTimestamp);
        }

        public final String getKinesisStreamARN() {
            return this.kinesisStreamARN;
        }

        @Override
        public final Builder kinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
            return this;
        }

        public final void setKinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Instant getDeliveryStartTimestamp() {
            return this.deliveryStartTimestamp;
        }

        @Override
        public final Builder deliveryStartTimestamp(Instant deliveryStartTimestamp) {
            this.deliveryStartTimestamp = deliveryStartTimestamp;
            return this;
        }

        public final void setDeliveryStartTimestamp(Instant deliveryStartTimestamp) {
            this.deliveryStartTimestamp = deliveryStartTimestamp;
        }

        public KinesisStreamSourceDescription build() {
            return new KinesisStreamSourceDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KinesisStreamSourceDescription> {
        public Builder kinesisStreamARN(String var1);

        public Builder roleARN(String var1);

        public Builder deliveryStartTimestamp(Instant var1);
    }
}

