/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordColumnsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat;
import software.amazon.awssdk.services.kinesisanalytics.transform.SourceSchemaMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SourceSchema
implements StructuredPojo,
ToCopyableBuilder<Builder, SourceSchema> {
    private final RecordFormat recordFormat;
    private final String recordEncoding;
    private final List<RecordColumn> recordColumns;

    private SourceSchema(BuilderImpl builder) {
        this.recordFormat = builder.recordFormat;
        this.recordEncoding = builder.recordEncoding;
        this.recordColumns = builder.recordColumns;
    }

    public RecordFormat recordFormat() {
        return this.recordFormat;
    }

    public String recordEncoding() {
        return this.recordEncoding;
    }

    public List<RecordColumn> recordColumns() {
        return this.recordColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.recordFormat() == null ? 0 : this.recordFormat().hashCode());
        hashCode = 31 * hashCode + (this.recordEncoding() == null ? 0 : this.recordEncoding().hashCode());
        hashCode = 31 * hashCode + (this.recordColumns() == null ? 0 : this.recordColumns().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceSchema)) {
            return false;
        }
        SourceSchema other = (SourceSchema)obj;
        if (other.recordFormat() == null ^ this.recordFormat() == null) {
            return false;
        }
        if (other.recordFormat() != null && !other.recordFormat().equals(this.recordFormat())) {
            return false;
        }
        if (other.recordEncoding() == null ^ this.recordEncoding() == null) {
            return false;
        }
        if (other.recordEncoding() != null && !other.recordEncoding().equals(this.recordEncoding())) {
            return false;
        }
        if (other.recordColumns() == null ^ this.recordColumns() == null) {
            return false;
        }
        return other.recordColumns() == null || other.recordColumns().equals(this.recordColumns());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.recordFormat() != null) {
            sb.append("RecordFormat: ").append(this.recordFormat()).append(",");
        }
        if (this.recordEncoding() != null) {
            sb.append("RecordEncoding: ").append(this.recordEncoding()).append(",");
        }
        if (this.recordColumns() != null) {
            sb.append("RecordColumns: ").append(this.recordColumns()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordFormat": {
                return Optional.of(clazz.cast(this.recordFormat()));
            }
            case "RecordEncoding": {
                return Optional.of(clazz.cast(this.recordEncoding()));
            }
            case "RecordColumns": {
                return Optional.of(clazz.cast(this.recordColumns()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceSchemaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private RecordFormat recordFormat;
        private String recordEncoding;
        private List<RecordColumn> recordColumns;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceSchema model) {
            this.recordFormat(model.recordFormat);
            this.recordEncoding(model.recordEncoding);
            this.recordColumns(model.recordColumns);
        }

        public final RecordFormat.Builder getRecordFormat() {
            return this.recordFormat != null ? this.recordFormat.toBuilder() : null;
        }

        @Override
        public final Builder recordFormat(RecordFormat recordFormat) {
            this.recordFormat = recordFormat;
            return this;
        }

        public final void setRecordFormat(RecordFormat.BuilderImpl recordFormat) {
            this.recordFormat = recordFormat != null ? recordFormat.build() : null;
        }

        public final String getRecordEncoding() {
            return this.recordEncoding;
        }

        @Override
        public final Builder recordEncoding(String recordEncoding) {
            this.recordEncoding = recordEncoding;
            return this;
        }

        public final void setRecordEncoding(String recordEncoding) {
            this.recordEncoding = recordEncoding;
        }

        public final Collection<RecordColumn.Builder> getRecordColumns() {
            return this.recordColumns != null ? (Collection)this.recordColumns.stream().map(RecordColumn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordColumns(Collection<RecordColumn> recordColumns) {
            this.recordColumns = RecordColumnsCopier.copy(recordColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordColumns(RecordColumn ... recordColumns) {
            this.recordColumns(Arrays.asList(recordColumns));
            return this;
        }

        public final void setRecordColumns(Collection<RecordColumn.BuilderImpl> recordColumns) {
            this.recordColumns = RecordColumnsCopier.copyFromBuilder(recordColumns);
        }

        public SourceSchema build() {
            return new SourceSchema(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SourceSchema> {
        public Builder recordFormat(RecordFormat var1);

        public Builder recordEncoding(String var1);

        public Builder recordColumns(Collection<RecordColumn> var1);

        public Builder recordColumns(RecordColumn ... var1);
    }
}

