/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.DestinationSchema;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseOutput;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutput;
import software.amazon.awssdk.services.kinesisanalytics.transform.OutputMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Output
implements StructuredPojo,
ToCopyableBuilder<Builder, Output> {
    private final String name;
    private final KinesisStreamsOutput kinesisStreamsOutput;
    private final KinesisFirehoseOutput kinesisFirehoseOutput;
    private final DestinationSchema destinationSchema;

    private Output(BuilderImpl builder) {
        this.name = builder.name;
        this.kinesisStreamsOutput = builder.kinesisStreamsOutput;
        this.kinesisFirehoseOutput = builder.kinesisFirehoseOutput;
        this.destinationSchema = builder.destinationSchema;
    }

    public String name() {
        return this.name;
    }

    public KinesisStreamsOutput kinesisStreamsOutput() {
        return this.kinesisStreamsOutput;
    }

    public KinesisFirehoseOutput kinesisFirehoseOutput() {
        return this.kinesisFirehoseOutput;
    }

    public DestinationSchema destinationSchema() {
        return this.destinationSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.kinesisStreamsOutput() == null ? 0 : this.kinesisStreamsOutput().hashCode());
        hashCode = 31 * hashCode + (this.kinesisFirehoseOutput() == null ? 0 : this.kinesisFirehoseOutput().hashCode());
        hashCode = 31 * hashCode + (this.destinationSchema() == null ? 0 : this.destinationSchema().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.kinesisStreamsOutput() == null ^ this.kinesisStreamsOutput() == null) {
            return false;
        }
        if (other.kinesisStreamsOutput() != null && !other.kinesisStreamsOutput().equals(this.kinesisStreamsOutput())) {
            return false;
        }
        if (other.kinesisFirehoseOutput() == null ^ this.kinesisFirehoseOutput() == null) {
            return false;
        }
        if (other.kinesisFirehoseOutput() != null && !other.kinesisFirehoseOutput().equals(this.kinesisFirehoseOutput())) {
            return false;
        }
        if (other.destinationSchema() == null ^ this.destinationSchema() == null) {
            return false;
        }
        return other.destinationSchema() == null || other.destinationSchema().equals(this.destinationSchema());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.kinesisStreamsOutput() != null) {
            sb.append("KinesisStreamsOutput: ").append(this.kinesisStreamsOutput()).append(",");
        }
        if (this.kinesisFirehoseOutput() != null) {
            sb.append("KinesisFirehoseOutput: ").append(this.kinesisFirehoseOutput()).append(",");
        }
        if (this.destinationSchema() != null) {
            sb.append("DestinationSchema: ").append(this.destinationSchema()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "KinesisStreamsOutput": {
                return Optional.of(clazz.cast(this.kinesisStreamsOutput()));
            }
            case "KinesisFirehoseOutput": {
                return Optional.of(clazz.cast(this.kinesisFirehoseOutput()));
            }
            case "DestinationSchema": {
                return Optional.of(clazz.cast(this.destinationSchema()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private KinesisStreamsOutput kinesisStreamsOutput;
        private KinesisFirehoseOutput kinesisFirehoseOutput;
        private DestinationSchema destinationSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            this.name(model.name);
            this.kinesisStreamsOutput(model.kinesisStreamsOutput);
            this.kinesisFirehoseOutput(model.kinesisFirehoseOutput);
            this.destinationSchema(model.destinationSchema);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final KinesisStreamsOutput.Builder getKinesisStreamsOutput() {
            return this.kinesisStreamsOutput != null ? this.kinesisStreamsOutput.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsOutput(KinesisStreamsOutput kinesisStreamsOutput) {
            this.kinesisStreamsOutput = kinesisStreamsOutput;
            return this;
        }

        public final void setKinesisStreamsOutput(KinesisStreamsOutput.BuilderImpl kinesisStreamsOutput) {
            this.kinesisStreamsOutput = kinesisStreamsOutput != null ? kinesisStreamsOutput.build() : null;
        }

        public final KinesisFirehoseOutput.Builder getKinesisFirehoseOutput() {
            return this.kinesisFirehoseOutput != null ? this.kinesisFirehoseOutput.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseOutput(KinesisFirehoseOutput kinesisFirehoseOutput) {
            this.kinesisFirehoseOutput = kinesisFirehoseOutput;
            return this;
        }

        public final void setKinesisFirehoseOutput(KinesisFirehoseOutput.BuilderImpl kinesisFirehoseOutput) {
            this.kinesisFirehoseOutput = kinesisFirehoseOutput != null ? kinesisFirehoseOutput.build() : null;
        }

        public final DestinationSchema.Builder getDestinationSchema() {
            return this.destinationSchema != null ? this.destinationSchema.toBuilder() : null;
        }

        @Override
        public final Builder destinationSchema(DestinationSchema destinationSchema) {
            this.destinationSchema = destinationSchema;
            return this;
        }

        public final void setDestinationSchema(DestinationSchema.BuilderImpl destinationSchema) {
            this.destinationSchema = destinationSchema != null ? destinationSchema.build() : null;
        }

        public Output build() {
            return new Output(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Output> {
        public Builder name(String var1);

        public Builder kinesisStreamsOutput(KinesisStreamsOutput var1);

        public Builder kinesisFirehoseOutput(KinesisFirehoseOutput var1);

        public Builder destinationSchema(DestinationSchema var1);
    }
}

