/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.kinesisanalytics.model.ParsedInputRecordsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.RawInputRecordsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DiscoverInputSchemaResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DiscoverInputSchemaResponse> {
    private final SourceSchema inputSchema;
    private final List<List<String>> parsedInputRecords;
    private final List<String> rawInputRecords;

    private DiscoverInputSchemaResponse(BuilderImpl builder) {
        this.inputSchema = builder.inputSchema;
        this.parsedInputRecords = builder.parsedInputRecords;
        this.rawInputRecords = builder.rawInputRecords;
    }

    public SourceSchema inputSchema() {
        return this.inputSchema;
    }

    public List<List<String>> parsedInputRecords() {
        return this.parsedInputRecords;
    }

    public List<String> rawInputRecords() {
        return this.rawInputRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.inputSchema() == null ? 0 : this.inputSchema().hashCode());
        hashCode = 31 * hashCode + (this.parsedInputRecords() == null ? 0 : this.parsedInputRecords().hashCode());
        hashCode = 31 * hashCode + (this.rawInputRecords() == null ? 0 : this.rawInputRecords().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInputSchemaResponse)) {
            return false;
        }
        DiscoverInputSchemaResponse other = (DiscoverInputSchemaResponse)((Object)obj);
        if (other.inputSchema() == null ^ this.inputSchema() == null) {
            return false;
        }
        if (other.inputSchema() != null && !other.inputSchema().equals(this.inputSchema())) {
            return false;
        }
        if (other.parsedInputRecords() == null ^ this.parsedInputRecords() == null) {
            return false;
        }
        if (other.parsedInputRecords() != null && !other.parsedInputRecords().equals(this.parsedInputRecords())) {
            return false;
        }
        if (other.rawInputRecords() == null ^ this.rawInputRecords() == null) {
            return false;
        }
        return other.rawInputRecords() == null || other.rawInputRecords().equals(this.rawInputRecords());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.inputSchema() != null) {
            sb.append("InputSchema: ").append(this.inputSchema()).append(",");
        }
        if (this.parsedInputRecords() != null) {
            sb.append("ParsedInputRecords: ").append(this.parsedInputRecords()).append(",");
        }
        if (this.rawInputRecords() != null) {
            sb.append("RawInputRecords: ").append(this.rawInputRecords()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputSchema": {
                return Optional.of(clazz.cast(this.inputSchema()));
            }
            case "ParsedInputRecords": {
                return Optional.of(clazz.cast(this.parsedInputRecords()));
            }
            case "RawInputRecords": {
                return Optional.of(clazz.cast(this.rawInputRecords()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private SourceSchema inputSchema;
        private List<List<String>> parsedInputRecords;
        private List<String> rawInputRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInputSchemaResponse model) {
            this.inputSchema(model.inputSchema);
            this.parsedInputRecords(model.parsedInputRecords);
            this.rawInputRecords(model.rawInputRecords);
        }

        public final SourceSchema.Builder getInputSchema() {
            return this.inputSchema != null ? this.inputSchema.toBuilder() : null;
        }

        @Override
        public final Builder inputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final void setInputSchema(SourceSchema.BuilderImpl inputSchema) {
            this.inputSchema = inputSchema != null ? inputSchema.build() : null;
        }

        public final Collection<? extends Collection<String>> getParsedInputRecords() {
            return this.parsedInputRecords;
        }

        @Override
        public final Builder parsedInputRecords(Collection<? extends Collection<String>> parsedInputRecords) {
            this.parsedInputRecords = ParsedInputRecordsCopier.copy(parsedInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parsedInputRecords(Collection<String> ... parsedInputRecords) {
            this.parsedInputRecords((Collection<? extends Collection<String>>)Arrays.asList(parsedInputRecords));
            return this;
        }

        public final void setParsedInputRecords(Collection<? extends Collection<String>> parsedInputRecords) {
            this.parsedInputRecords = ParsedInputRecordsCopier.copy(parsedInputRecords);
        }

        public final Collection<String> getRawInputRecords() {
            return this.rawInputRecords;
        }

        @Override
        public final Builder rawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rawInputRecords(String ... rawInputRecords) {
            this.rawInputRecords(Arrays.asList(rawInputRecords));
            return this;
        }

        public final void setRawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
        }

        public DiscoverInputSchemaResponse build() {
            return new DiscoverInputSchemaResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DiscoverInputSchemaResponse> {
        public Builder inputSchema(SourceSchema var1);

        public Builder parsedInputRecords(Collection<? extends Collection<String>> var1);

        public Builder parsedInputRecords(Collection<String> ... var1);

        public Builder rawInputRecords(Collection<String> var1);

        public Builder rawInputRecords(String ... var1);
    }
}

