/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.kinesis.model.Tag;
import software.amazon.awssdk.services.kinesis.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTagsForStreamResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTagsForStreamResponse> {
    private final List<Tag> tags;
    private final Boolean hasMoreTags;

    private ListTagsForStreamResponse(BuilderImpl builder) {
        this.tags = builder.tags;
        this.hasMoreTags = builder.hasMoreTags;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean hasMoreTags() {
        return this.hasMoreTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.hasMoreTags() == null ? 0 : this.hasMoreTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamResponse)) {
            return false;
        }
        ListTagsForStreamResponse other = (ListTagsForStreamResponse)((Object)obj);
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.hasMoreTags() == null ^ this.hasMoreTags() == null) {
            return false;
        }
        return other.hasMoreTags() == null || other.hasMoreTags().equals(this.hasMoreTags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.hasMoreTags() != null) {
            sb.append("HasMoreTags: ").append(this.hasMoreTags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "HasMoreTags": {
                return Optional.of(clazz.cast(this.hasMoreTags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Tag> tags;
        private Boolean hasMoreTags;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForStreamResponse model) {
            this.tags(model.tags);
            this.hasMoreTags(model.hasMoreTags);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getHasMoreTags() {
            return this.hasMoreTags;
        }

        @Override
        public final Builder hasMoreTags(Boolean hasMoreTags) {
            this.hasMoreTags = hasMoreTags;
            return this;
        }

        public final void setHasMoreTags(Boolean hasMoreTags) {
            this.hasMoreTags = hasMoreTags;
        }

        public ListTagsForStreamResponse build() {
            return new ListTagsForStreamResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTagsForStreamResponse> {
        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder hasMoreTags(Boolean var1);
    }
}

