/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.ProcessorParameterName;
import software.amazon.awssdk.services.firehose.transform.ProcessorParameterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProcessorParameter
implements StructuredPojo,
ToCopyableBuilder<Builder, ProcessorParameter> {
    private final String parameterName;
    private final String parameterValue;

    private ProcessorParameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterValue = builder.parameterValue;
    }

    public ProcessorParameterName parameterName() {
        return ProcessorParameterName.fromValue(this.parameterName);
    }

    public String parameterNameString() {
        return this.parameterName;
    }

    public String parameterValue() {
        return this.parameterValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parameterNameString() == null ? 0 : this.parameterNameString().hashCode());
        hashCode = 31 * hashCode + (this.parameterValue() == null ? 0 : this.parameterValue().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessorParameter)) {
            return false;
        }
        ProcessorParameter other = (ProcessorParameter)obj;
        if (other.parameterNameString() == null ^ this.parameterNameString() == null) {
            return false;
        }
        if (other.parameterNameString() != null && !other.parameterNameString().equals(this.parameterNameString())) {
            return false;
        }
        if (other.parameterValue() == null ^ this.parameterValue() == null) {
            return false;
        }
        return other.parameterValue() == null || other.parameterValue().equals(this.parameterValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parameterNameString() != null) {
            sb.append("ParameterName: ").append(this.parameterNameString()).append(",");
        }
        if (this.parameterValue() != null) {
            sb.append("ParameterValue: ").append(this.parameterValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterName": {
                return Optional.of(clazz.cast(this.parameterNameString()));
            }
            case "ParameterValue": {
                return Optional.of(clazz.cast(this.parameterValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProcessorParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterName;
        private String parameterValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessorParameter model) {
            this.parameterName(model.parameterName);
            this.parameterValue(model.parameterValue);
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        @Override
        public final Builder parameterName(ProcessorParameterName parameterName) {
            this.parameterName(parameterName.toString());
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterValue() {
            return this.parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public ProcessorParameter build() {
            return new ProcessorParameter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProcessorParameter> {
        public Builder parameterName(String var1);

        public Builder parameterName(ProcessorParameterName var1);

        public Builder parameterValue(String var1);
    }
}

