/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteApplicationCloudWatchLoggingOptionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteApplicationCloudWatchLoggingOptionRequest> {
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final String cloudWatchLoggingOptionId;

    private DeleteApplicationCloudWatchLoggingOptionRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.cloudWatchLoggingOptionId = builder.cloudWatchLoggingOptionId;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public String cloudWatchLoggingOptionId() {
        return this.cloudWatchLoggingOptionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.currentApplicationVersionId() == null ? 0 : this.currentApplicationVersionId().hashCode());
        hashCode = 31 * hashCode + (this.cloudWatchLoggingOptionId() == null ? 0 : this.cloudWatchLoggingOptionId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationCloudWatchLoggingOptionRequest)) {
            return false;
        }
        DeleteApplicationCloudWatchLoggingOptionRequest other = (DeleteApplicationCloudWatchLoggingOptionRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.currentApplicationVersionId() == null ^ this.currentApplicationVersionId() == null) {
            return false;
        }
        if (other.currentApplicationVersionId() != null && !other.currentApplicationVersionId().equals(this.currentApplicationVersionId())) {
            return false;
        }
        if (other.cloudWatchLoggingOptionId() == null ^ this.cloudWatchLoggingOptionId() == null) {
            return false;
        }
        return other.cloudWatchLoggingOptionId() == null || other.cloudWatchLoggingOptionId().equals(this.cloudWatchLoggingOptionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(this.currentApplicationVersionId()).append(",");
        }
        if (this.cloudWatchLoggingOptionId() != null) {
            sb.append("CloudWatchLoggingOptionId: ").append(this.cloudWatchLoggingOptionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private String cloudWatchLoggingOptionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationCloudWatchLoggingOptionRequest model) {
            this.setApplicationName(model.applicationName);
            this.setCurrentApplicationVersionId(model.currentApplicationVersionId);
            this.setCloudWatchLoggingOptionId(model.cloudWatchLoggingOptionId);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final String getCloudWatchLoggingOptionId() {
            return this.cloudWatchLoggingOptionId;
        }

        @Override
        public final Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
            return this;
        }

        public final void setCloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
        }

        public DeleteApplicationCloudWatchLoggingOptionRequest build() {
            return new DeleteApplicationCloudWatchLoggingOptionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteApplicationCloudWatchLoggingOptionRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder cloudWatchLoggingOptionId(String var1);
    }
}

