/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.Input;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddApplicationInputRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddApplicationInputRequest> {
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final Input input;

    private AddApplicationInputRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.input = builder.input;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public Input input() {
        return this.input;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.currentApplicationVersionId() == null ? 0 : this.currentApplicationVersionId().hashCode());
        hashCode = 31 * hashCode + (this.input() == null ? 0 : this.input().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationInputRequest)) {
            return false;
        }
        AddApplicationInputRequest other = (AddApplicationInputRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.currentApplicationVersionId() == null ^ this.currentApplicationVersionId() == null) {
            return false;
        }
        if (other.currentApplicationVersionId() != null && !other.currentApplicationVersionId().equals(this.currentApplicationVersionId())) {
            return false;
        }
        if (other.input() == null ^ this.input() == null) {
            return false;
        }
        return other.input() == null || other.input().equals(this.input());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(this.currentApplicationVersionId()).append(",");
        }
        if (this.input() != null) {
            sb.append("Input: ").append(this.input()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private Input input;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationInputRequest model) {
            this.setApplicationName(model.applicationName);
            this.setCurrentApplicationVersionId(model.currentApplicationVersionId);
            this.setInput(model.input);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final Input getInput() {
            return this.input;
        }

        @Override
        public final Builder input(Input input) {
            this.input = input;
            return this;
        }

        public final void setInput(Input input) {
            this.input = input;
        }

        public AddApplicationInputRequest build() {
            return new AddApplicationInputRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddApplicationInputRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder input(Input var1);
    }
}

