/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.S3ReferenceDataSourceDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3ReferenceDataSourceDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, S3ReferenceDataSourceDescription> {
    private final String bucketARN;
    private final String fileKey;
    private final String referenceRoleARN;

    private S3ReferenceDataSourceDescription(BuilderImpl builder) {
        this.bucketARN = builder.bucketARN;
        this.fileKey = builder.fileKey;
        this.referenceRoleARN = builder.referenceRoleARN;
    }

    public String bucketARN() {
        return this.bucketARN;
    }

    public String fileKey() {
        return this.fileKey;
    }

    public String referenceRoleARN() {
        return this.referenceRoleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucketARN() == null ? 0 : this.bucketARN().hashCode());
        hashCode = 31 * hashCode + (this.fileKey() == null ? 0 : this.fileKey().hashCode());
        hashCode = 31 * hashCode + (this.referenceRoleARN() == null ? 0 : this.referenceRoleARN().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ReferenceDataSourceDescription)) {
            return false;
        }
        S3ReferenceDataSourceDescription other = (S3ReferenceDataSourceDescription)obj;
        if (other.bucketARN() == null ^ this.bucketARN() == null) {
            return false;
        }
        if (other.bucketARN() != null && !other.bucketARN().equals(this.bucketARN())) {
            return false;
        }
        if (other.fileKey() == null ^ this.fileKey() == null) {
            return false;
        }
        if (other.fileKey() != null && !other.fileKey().equals(this.fileKey())) {
            return false;
        }
        if (other.referenceRoleARN() == null ^ this.referenceRoleARN() == null) {
            return false;
        }
        return other.referenceRoleARN() == null || other.referenceRoleARN().equals(this.referenceRoleARN());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucketARN() != null) {
            sb.append("BucketARN: ").append(this.bucketARN()).append(",");
        }
        if (this.fileKey() != null) {
            sb.append("FileKey: ").append(this.fileKey()).append(",");
        }
        if (this.referenceRoleARN() != null) {
            sb.append("ReferenceRoleARN: ").append(this.referenceRoleARN()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ReferenceDataSourceDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucketARN;
        private String fileKey;
        private String referenceRoleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ReferenceDataSourceDescription model) {
            this.setBucketARN(model.bucketARN);
            this.setFileKey(model.fileKey);
            this.setReferenceRoleARN(model.referenceRoleARN);
        }

        public final String getBucketARN() {
            return this.bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getFileKey() {
            return this.fileKey;
        }

        @Override
        public final Builder fileKey(String fileKey) {
            this.fileKey = fileKey;
            return this;
        }

        public final void setFileKey(String fileKey) {
            this.fileKey = fileKey;
        }

        public final String getReferenceRoleARN() {
            return this.referenceRoleARN;
        }

        @Override
        public final Builder referenceRoleARN(String referenceRoleARN) {
            this.referenceRoleARN = referenceRoleARN;
            return this;
        }

        public final void setReferenceRoleARN(String referenceRoleARN) {
            this.referenceRoleARN = referenceRoleARN;
        }

        public S3ReferenceDataSourceDescription build() {
            return new S3ReferenceDataSourceDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3ReferenceDataSourceDescription> {
        public Builder bucketARN(String var1);

        public Builder fileKey(String var1);

        public Builder referenceRoleARN(String var1);
    }
}

