/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.RedshiftRetryOptionsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RedshiftRetryOptions
implements StructuredPojo,
ToCopyableBuilder<Builder, RedshiftRetryOptions> {
    private final Integer durationInSeconds;

    private RedshiftRetryOptions(BuilderImpl builder) {
        this.durationInSeconds = builder.durationInSeconds;
    }

    public Integer durationInSeconds() {
        return this.durationInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.durationInSeconds() == null ? 0 : this.durationInSeconds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftRetryOptions)) {
            return false;
        }
        RedshiftRetryOptions other = (RedshiftRetryOptions)obj;
        if (other.durationInSeconds() == null ^ this.durationInSeconds() == null) {
            return false;
        }
        return other.durationInSeconds() == null || other.durationInSeconds().equals(this.durationInSeconds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.durationInSeconds() != null) {
            sb.append("DurationInSeconds: ").append(this.durationInSeconds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftRetryOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer durationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftRetryOptions model) {
            this.setDurationInSeconds(model.durationInSeconds);
        }

        public final Integer getDurationInSeconds() {
            return this.durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        public RedshiftRetryOptions build() {
            return new RedshiftRetryOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RedshiftRetryOptions> {
        public Builder durationInSeconds(Integer var1);
    }
}

