/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.KMSEncryptionConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KMSEncryptionConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, KMSEncryptionConfig> {
    private final String awskmsKeyARN;

    private KMSEncryptionConfig(BuilderImpl builder) {
        this.awskmsKeyARN = builder.awskmsKeyARN;
    }

    public String awskmsKeyARN() {
        return this.awskmsKeyARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.awskmsKeyARN() == null ? 0 : this.awskmsKeyARN().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KMSEncryptionConfig)) {
            return false;
        }
        KMSEncryptionConfig other = (KMSEncryptionConfig)obj;
        if (other.awskmsKeyARN() == null ^ this.awskmsKeyARN() == null) {
            return false;
        }
        return other.awskmsKeyARN() == null || other.awskmsKeyARN().equals(this.awskmsKeyARN());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.awskmsKeyARN() != null) {
            sb.append("AWSKMSKeyARN: ").append(this.awskmsKeyARN()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KMSEncryptionConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String awskmsKeyARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KMSEncryptionConfig model) {
            this.setAWSKMSKeyARN(model.awskmsKeyARN);
        }

        public final String getAWSKMSKeyARN() {
            return this.awskmsKeyARN;
        }

        @Override
        public final Builder awskmsKeyARN(String awskmsKeyARN) {
            this.awskmsKeyARN = awskmsKeyARN;
            return this;
        }

        public final void setAWSKMSKeyARN(String awskmsKeyARN) {
            this.awskmsKeyARN = awskmsKeyARN;
        }

        public KMSEncryptionConfig build() {
            return new KMSEncryptionConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KMSEncryptionConfig> {
        public Builder awskmsKeyARN(String var1);
    }
}

