/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.MappingParameters;
import software.amazon.awssdk.services.kinesisanalytics.transform.CSVMappingParametersUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.JSONMappingParametersUnmarshaller;

public class MappingParametersUnmarshaller
implements Unmarshaller<MappingParameters, JsonUnmarshallerContext> {
    private static MappingParametersUnmarshaller INSTANCE;

    public MappingParameters unmarshall(JsonUnmarshallerContext context) throws Exception {
        MappingParameters.Builder mappingParametersBuilder = MappingParameters.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("JSONMappingParameters", targetDepth)) {
                    context.nextToken();
                    mappingParametersBuilder.jsonMappingParameters(JSONMappingParametersUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CSVMappingParameters", targetDepth)) {
                    context.nextToken();
                    mappingParametersBuilder.csvMappingParameters(CSVMappingParametersUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (MappingParameters)mappingParametersBuilder.build();
    }

    public static MappingParametersUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MappingParametersUnmarshaller();
        }
        return INSTANCE;
    }
}

