/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.InputDescription;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputParallelismUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputStartingPositionConfigurationUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisFirehoseInputDescriptionUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisStreamsInputDescriptionUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.SourceSchemaUnmarshaller;

public class InputDescriptionUnmarshaller
implements Unmarshaller<InputDescription, JsonUnmarshallerContext> {
    private static InputDescriptionUnmarshaller INSTANCE;

    public InputDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        InputDescription.Builder inputDescriptionBuilder = InputDescription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("InputId", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.inputId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NamePrefix", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.namePrefix((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InAppStreamNames", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.inAppStreamNames(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("KinesisStreamsInputDescription", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.kinesisStreamsInputDescription(KinesisStreamsInputDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("KinesisFirehoseInputDescription", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.kinesisFirehoseInputDescription(KinesisFirehoseInputDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("InputSchema", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.inputSchema(SourceSchemaUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("InputParallelism", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.inputParallelism(InputParallelismUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("InputStartingPositionConfiguration", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.inputStartingPositionConfiguration(InputStartingPositionConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InputDescription)inputDescriptionBuilder.build();
    }

    public static InputDescriptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InputDescriptionUnmarshaller();
        }
        return INSTANCE;
    }
}

