/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.DestinationSchema;

@SdkInternalApi
public class DestinationSchemaMarshaller {
    private static final MarshallingInfo<String> RECORDFORMATTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordFormatType").build();
    private static final DestinationSchemaMarshaller instance = new DestinationSchemaMarshaller();

    public static DestinationSchemaMarshaller getInstance() {
        return instance;
    }

    public void marshall(DestinationSchema destinationSchema, ProtocolMarshaller protocolMarshaller) {
        if (destinationSchema == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)destinationSchema.recordFormatType(), RECORDFORMATTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

