/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.CSVMappingParametersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CSVMappingParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, CSVMappingParameters> {
    private final String recordRowDelimiter;
    private final String recordColumnDelimiter;

    private CSVMappingParameters(BuilderImpl builder) {
        this.recordRowDelimiter = builder.recordRowDelimiter;
        this.recordColumnDelimiter = builder.recordColumnDelimiter;
    }

    public String recordRowDelimiter() {
        return this.recordRowDelimiter;
    }

    public String recordColumnDelimiter() {
        return this.recordColumnDelimiter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.recordRowDelimiter() == null ? 0 : this.recordRowDelimiter().hashCode());
        hashCode = 31 * hashCode + (this.recordColumnDelimiter() == null ? 0 : this.recordColumnDelimiter().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CSVMappingParameters)) {
            return false;
        }
        CSVMappingParameters other = (CSVMappingParameters)obj;
        if (other.recordRowDelimiter() == null ^ this.recordRowDelimiter() == null) {
            return false;
        }
        if (other.recordRowDelimiter() != null && !other.recordRowDelimiter().equals(this.recordRowDelimiter())) {
            return false;
        }
        if (other.recordColumnDelimiter() == null ^ this.recordColumnDelimiter() == null) {
            return false;
        }
        return other.recordColumnDelimiter() == null || other.recordColumnDelimiter().equals(this.recordColumnDelimiter());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.recordRowDelimiter() != null) {
            sb.append("RecordRowDelimiter: ").append(this.recordRowDelimiter()).append(",");
        }
        if (this.recordColumnDelimiter() != null) {
            sb.append("RecordColumnDelimiter: ").append(this.recordColumnDelimiter()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CSVMappingParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String recordRowDelimiter;
        private String recordColumnDelimiter;

        private BuilderImpl() {
        }

        private BuilderImpl(CSVMappingParameters model) {
            this.setRecordRowDelimiter(model.recordRowDelimiter);
            this.setRecordColumnDelimiter(model.recordColumnDelimiter);
        }

        public final String getRecordRowDelimiter() {
            return this.recordRowDelimiter;
        }

        @Override
        public final Builder recordRowDelimiter(String recordRowDelimiter) {
            this.recordRowDelimiter = recordRowDelimiter;
            return this;
        }

        public final void setRecordRowDelimiter(String recordRowDelimiter) {
            this.recordRowDelimiter = recordRowDelimiter;
        }

        public final String getRecordColumnDelimiter() {
            return this.recordColumnDelimiter;
        }

        @Override
        public final Builder recordColumnDelimiter(String recordColumnDelimiter) {
            this.recordColumnDelimiter = recordColumnDelimiter;
            return this;
        }

        public final void setRecordColumnDelimiter(String recordColumnDelimiter) {
            this.recordColumnDelimiter = recordColumnDelimiter;
        }

        public CSVMappingParameters build() {
            return new CSVMappingParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CSVMappingParameters> {
        public Builder recordRowDelimiter(String var1);

        public Builder recordColumnDelimiter(String var1);
    }
}

