/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.StreamDescription;

@SdkInternalApi
public class StreamDescriptionMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamARN").build();
    private static final MarshallingInfo<String> STREAMSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamStatus").build();
    private static final MarshallingInfo<List> SHARDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Shards").build();
    private static final MarshallingInfo<Boolean> HASMORESHARDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasMoreShards").build();
    private static final MarshallingInfo<Integer> RETENTIONPERIODHOURS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetentionPeriodHours").build();
    private static final MarshallingInfo<Instant> STREAMCREATIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamCreationTimestamp").build();
    private static final MarshallingInfo<List> ENHANCEDMONITORING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnhancedMonitoring").build();
    private static final StreamDescriptionMarshaller instance = new StreamDescriptionMarshaller();

    public static StreamDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(StreamDescription streamDescription, ProtocolMarshaller protocolMarshaller) {
        if (streamDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)streamDescription.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)streamDescription.streamARN(), STREAMARN_BINDING);
            protocolMarshaller.marshall((Object)streamDescription.streamStatus(), STREAMSTATUS_BINDING);
            protocolMarshaller.marshall(streamDescription.shards(), SHARDS_BINDING);
            protocolMarshaller.marshall((Object)streamDescription.hasMoreShards(), HASMORESHARDS_BINDING);
            protocolMarshaller.marshall((Object)streamDescription.retentionPeriodHours(), RETENTIONPERIODHOURS_BINDING);
            protocolMarshaller.marshall((Object)streamDescription.streamCreationTimestamp(), STREAMCREATIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall(streamDescription.enhancedMonitoring(), ENHANCEDMONITORING_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

