/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SplitShardRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SplitShardRequest> {
    private final String streamName;
    private final String shardToSplit;
    private final String newStartingHashKey;

    private SplitShardRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.shardToSplit = builder.shardToSplit;
        this.newStartingHashKey = builder.newStartingHashKey;
    }

    public String streamName() {
        return this.streamName;
    }

    public String shardToSplit() {
        return this.shardToSplit;
    }

    public String newStartingHashKey() {
        return this.newStartingHashKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamName() == null ? 0 : this.streamName().hashCode());
        hashCode = 31 * hashCode + (this.shardToSplit() == null ? 0 : this.shardToSplit().hashCode());
        hashCode = 31 * hashCode + (this.newStartingHashKey() == null ? 0 : this.newStartingHashKey().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SplitShardRequest)) {
            return false;
        }
        SplitShardRequest other = (SplitShardRequest)((Object)obj);
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.shardToSplit() == null ^ this.shardToSplit() == null) {
            return false;
        }
        if (other.shardToSplit() != null && !other.shardToSplit().equals(this.shardToSplit())) {
            return false;
        }
        if (other.newStartingHashKey() == null ^ this.newStartingHashKey() == null) {
            return false;
        }
        return other.newStartingHashKey() == null || other.newStartingHashKey().equals(this.newStartingHashKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.shardToSplit() != null) {
            sb.append("ShardToSplit: ").append(this.shardToSplit()).append(",");
        }
        if (this.newStartingHashKey() != null) {
            sb.append("NewStartingHashKey: ").append(this.newStartingHashKey()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String shardToSplit;
        private String newStartingHashKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SplitShardRequest model) {
            this.setStreamName(model.streamName);
            this.setShardToSplit(model.shardToSplit);
            this.setNewStartingHashKey(model.newStartingHashKey);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getShardToSplit() {
            return this.shardToSplit;
        }

        @Override
        public final Builder shardToSplit(String shardToSplit) {
            this.shardToSplit = shardToSplit;
            return this;
        }

        public final void setShardToSplit(String shardToSplit) {
            this.shardToSplit = shardToSplit;
        }

        public final String getNewStartingHashKey() {
            return this.newStartingHashKey;
        }

        @Override
        public final Builder newStartingHashKey(String newStartingHashKey) {
            this.newStartingHashKey = newStartingHashKey;
            return this;
        }

        public final void setNewStartingHashKey(String newStartingHashKey) {
            this.newStartingHashKey = newStartingHashKey;
        }

        public SplitShardRequest build() {
            return new SplitShardRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SplitShardRequest> {
        public Builder streamName(String var1);

        public Builder shardToSplit(String var1);

        public Builder newStartingHashKey(String var1);
    }
}

