/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.model.HashKeyRange;
import software.amazon.awssdk.services.kinesis.model.SequenceNumberRange;
import software.amazon.awssdk.services.kinesis.transform.ShardMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Shard
implements StructuredPojo,
ToCopyableBuilder<Builder, Shard> {
    private final String shardId;
    private final String parentShardId;
    private final String adjacentParentShardId;
    private final HashKeyRange hashKeyRange;
    private final SequenceNumberRange sequenceNumberRange;

    private Shard(BuilderImpl builder) {
        this.shardId = builder.shardId;
        this.parentShardId = builder.parentShardId;
        this.adjacentParentShardId = builder.adjacentParentShardId;
        this.hashKeyRange = builder.hashKeyRange;
        this.sequenceNumberRange = builder.sequenceNumberRange;
    }

    public String shardId() {
        return this.shardId;
    }

    public String parentShardId() {
        return this.parentShardId;
    }

    public String adjacentParentShardId() {
        return this.adjacentParentShardId;
    }

    public HashKeyRange hashKeyRange() {
        return this.hashKeyRange;
    }

    public SequenceNumberRange sequenceNumberRange() {
        return this.sequenceNumberRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.shardId() == null ? 0 : this.shardId().hashCode());
        hashCode = 31 * hashCode + (this.parentShardId() == null ? 0 : this.parentShardId().hashCode());
        hashCode = 31 * hashCode + (this.adjacentParentShardId() == null ? 0 : this.adjacentParentShardId().hashCode());
        hashCode = 31 * hashCode + (this.hashKeyRange() == null ? 0 : this.hashKeyRange().hashCode());
        hashCode = 31 * hashCode + (this.sequenceNumberRange() == null ? 0 : this.sequenceNumberRange().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shard)) {
            return false;
        }
        Shard other = (Shard)obj;
        if (other.shardId() == null ^ this.shardId() == null) {
            return false;
        }
        if (other.shardId() != null && !other.shardId().equals(this.shardId())) {
            return false;
        }
        if (other.parentShardId() == null ^ this.parentShardId() == null) {
            return false;
        }
        if (other.parentShardId() != null && !other.parentShardId().equals(this.parentShardId())) {
            return false;
        }
        if (other.adjacentParentShardId() == null ^ this.adjacentParentShardId() == null) {
            return false;
        }
        if (other.adjacentParentShardId() != null && !other.adjacentParentShardId().equals(this.adjacentParentShardId())) {
            return false;
        }
        if (other.hashKeyRange() == null ^ this.hashKeyRange() == null) {
            return false;
        }
        if (other.hashKeyRange() != null && !other.hashKeyRange().equals(this.hashKeyRange())) {
            return false;
        }
        if (other.sequenceNumberRange() == null ^ this.sequenceNumberRange() == null) {
            return false;
        }
        return other.sequenceNumberRange() == null || other.sequenceNumberRange().equals(this.sequenceNumberRange());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.shardId() != null) {
            sb.append("ShardId: ").append(this.shardId()).append(",");
        }
        if (this.parentShardId() != null) {
            sb.append("ParentShardId: ").append(this.parentShardId()).append(",");
        }
        if (this.adjacentParentShardId() != null) {
            sb.append("AdjacentParentShardId: ").append(this.adjacentParentShardId()).append(",");
        }
        if (this.hashKeyRange() != null) {
            sb.append("HashKeyRange: ").append(this.hashKeyRange()).append(",");
        }
        if (this.sequenceNumberRange() != null) {
            sb.append("SequenceNumberRange: ").append(this.sequenceNumberRange()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShardMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String shardId;
        private String parentShardId;
        private String adjacentParentShardId;
        private HashKeyRange hashKeyRange;
        private SequenceNumberRange sequenceNumberRange;

        private BuilderImpl() {
        }

        private BuilderImpl(Shard model) {
            this.setShardId(model.shardId);
            this.setParentShardId(model.parentShardId);
            this.setAdjacentParentShardId(model.adjacentParentShardId);
            this.setHashKeyRange(model.hashKeyRange);
            this.setSequenceNumberRange(model.sequenceNumberRange);
        }

        public final String getShardId() {
            return this.shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getParentShardId() {
            return this.parentShardId;
        }

        @Override
        public final Builder parentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
            return this;
        }

        public final void setParentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
        }

        public final String getAdjacentParentShardId() {
            return this.adjacentParentShardId;
        }

        @Override
        public final Builder adjacentParentShardId(String adjacentParentShardId) {
            this.adjacentParentShardId = adjacentParentShardId;
            return this;
        }

        public final void setAdjacentParentShardId(String adjacentParentShardId) {
            this.adjacentParentShardId = adjacentParentShardId;
        }

        public final HashKeyRange getHashKeyRange() {
            return this.hashKeyRange;
        }

        @Override
        public final Builder hashKeyRange(HashKeyRange hashKeyRange) {
            this.hashKeyRange = hashKeyRange;
            return this;
        }

        public final void setHashKeyRange(HashKeyRange hashKeyRange) {
            this.hashKeyRange = hashKeyRange;
        }

        public final SequenceNumberRange getSequenceNumberRange() {
            return this.sequenceNumberRange;
        }

        @Override
        public final Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange;
            return this;
        }

        public final void setSequenceNumberRange(SequenceNumberRange sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange;
        }

        public Shard build() {
            return new Shard(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Shard> {
        public Builder shardId(String var1);

        public Builder parentShardId(String var1);

        public Builder adjacentParentShardId(String var1);

        public Builder hashKeyRange(HashKeyRange var1);

        public Builder sequenceNumberRange(SequenceNumberRange var1);
    }
}

