/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest;
import software.amazon.awssdk.services.kinesis.model.AddTagsToStreamResponse;
import software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesis.model.CreateStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodResponse;
import software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DeleteStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse;
import software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest;
import software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringResponse;
import software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest;
import software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringResponse;
import software.amazon.awssdk.services.kinesis.model.ExpiredIteratorException;
import software.amazon.awssdk.services.kinesis.model.ExpiredNextTokenException;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodResponse;
import software.amazon.awssdk.services.kinesis.model.InternalFailureException;
import software.amazon.awssdk.services.kinesis.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesis.model.KinesisException;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.services.kinesis.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.kinesis.model.KmsDisabledException;
import software.amazon.awssdk.services.kinesis.model.KmsInvalidStateException;
import software.amazon.awssdk.services.kinesis.model.KmsNotFoundException;
import software.amazon.awssdk.services.kinesis.model.KmsOptInRequiredException;
import software.amazon.awssdk.services.kinesis.model.KmsThrottlingException;
import software.amazon.awssdk.services.kinesis.model.LimitExceededException;
import software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.awssdk.services.kinesis.model.ListShardsResponse;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse;
import software.amazon.awssdk.services.kinesis.model.ListStreamsRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamsResponse;
import software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest;
import software.amazon.awssdk.services.kinesis.model.ListTagsForStreamResponse;
import software.amazon.awssdk.services.kinesis.model.MergeShardsRequest;
import software.amazon.awssdk.services.kinesis.model.MergeShardsResponse;
import software.amazon.awssdk.services.kinesis.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest;
import software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamResponse;
import software.amazon.awssdk.services.kinesis.model.ResourceInUseException;
import software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesis.model.SplitShardRequest;
import software.amazon.awssdk.services.kinesis.model.SplitShardResponse;
import software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest;
import software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionResponse;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionResponse;
import software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest;
import software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse;
import software.amazon.awssdk.services.kinesis.paginators.ListStreamConsumersIterable;
import software.amazon.awssdk.services.kinesis.transform.AddTagsToStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.AddTagsToStreamResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.CreateStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.CreateStreamResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.DecreaseStreamRetentionPeriodRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DecreaseStreamRetentionPeriodResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.DeleteStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DeleteStreamResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.DeregisterStreamConsumerRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DeregisterStreamConsumerResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.DescribeLimitsRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DescribeLimitsResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.DescribeStreamConsumerRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DescribeStreamConsumerResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.DescribeStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DescribeStreamResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.DescribeStreamSummaryRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DescribeStreamSummaryResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.DisableEnhancedMonitoringRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.DisableEnhancedMonitoringResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.EnableEnhancedMonitoringRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.EnableEnhancedMonitoringResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.GetRecordsRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.GetRecordsResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.GetShardIteratorRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.GetShardIteratorResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.IncreaseStreamRetentionPeriodRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.IncreaseStreamRetentionPeriodResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.ListShardsRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.ListShardsResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.ListStreamConsumersRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.ListStreamConsumersResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.ListStreamsRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.ListStreamsResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.ListTagsForStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.ListTagsForStreamResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.MergeShardsRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.MergeShardsResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.PutRecordRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.PutRecordResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.PutRecordsRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.PutRecordsResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.RegisterStreamConsumerRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.RegisterStreamConsumerResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.RemoveTagsFromStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.RemoveTagsFromStreamResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.SplitShardRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.SplitShardResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.StartStreamEncryptionRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.StartStreamEncryptionResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.StopStreamEncryptionRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.StopStreamEncryptionResponseUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.UpdateShardCountRequestMarshaller;
import software.amazon.awssdk.services.kinesis.transform.UpdateShardCountResponseUnmarshaller;

@SdkInternalApi
final class DefaultKinesisClient
implements KinesisClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKinesisClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(true);
    }

    public final String serviceName() {
        return "kinesis";
    }

    @Override
    public AddTagsToStreamResponse addTagsToStream(AddTagsToStreamRequest addTagsToStreamRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddTagsToStreamResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (AddTagsToStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsToStreamRequest).withMarshaller((Marshaller)new AddTagsToStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateStreamResponse createStream(CreateStreamRequest createStreamRequest) throws ResourceInUseException, LimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateStreamResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStreamRequest).withMarshaller((Marshaller)new CreateStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DecreaseStreamRetentionPeriodResponse decreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest decreaseStreamRetentionPeriodRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DecreaseStreamRetentionPeriodResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DecreaseStreamRetentionPeriodResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)decreaseStreamRetentionPeriodRequest).withMarshaller((Marshaller)new DecreaseStreamRetentionPeriodRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteStreamResponse deleteStream(DeleteStreamRequest deleteStreamRequest) throws ResourceNotFoundException, LimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteStreamResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteStreamRequest).withMarshaller((Marshaller)new DeleteStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeregisterStreamConsumerResponse deregisterStreamConsumer(DeregisterStreamConsumerRequest deregisterStreamConsumerRequest) throws LimitExceededException, ResourceNotFoundException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeregisterStreamConsumerResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeregisterStreamConsumerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterStreamConsumerRequest).withMarshaller((Marshaller)new DeregisterStreamConsumerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeLimitsResponse describeLimits(DescribeLimitsRequest describeLimitsRequest) throws LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLimitsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLimitsRequest).withMarshaller((Marshaller)new DescribeLimitsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeStreamResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStreamRequest).withMarshaller((Marshaller)new DescribeStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStreamConsumerResponse describeStreamConsumer(DescribeStreamConsumerRequest describeStreamConsumerRequest) throws LimitExceededException, ResourceNotFoundException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeStreamConsumerResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeStreamConsumerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStreamConsumerRequest).withMarshaller((Marshaller)new DescribeStreamConsumerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStreamSummaryResponse describeStreamSummary(DescribeStreamSummaryRequest describeStreamSummaryRequest) throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeStreamSummaryResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeStreamSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStreamSummaryRequest).withMarshaller((Marshaller)new DescribeStreamSummaryRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisableEnhancedMonitoringResponse disableEnhancedMonitoring(DisableEnhancedMonitoringRequest disableEnhancedMonitoringRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableEnhancedMonitoringResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DisableEnhancedMonitoringResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableEnhancedMonitoringRequest).withMarshaller((Marshaller)new DisableEnhancedMonitoringRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public EnableEnhancedMonitoringResponse enableEnhancedMonitoring(EnableEnhancedMonitoringRequest enableEnhancedMonitoringRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableEnhancedMonitoringResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (EnableEnhancedMonitoringResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableEnhancedMonitoringRequest).withMarshaller((Marshaller)new EnableEnhancedMonitoringRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetRecordsResponse getRecords(GetRecordsRequest getRecordsRequest) throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException, ExpiredIteratorException, KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRecordsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRecordsRequest).withMarshaller((Marshaller)new GetRecordsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetShardIteratorResponse getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetShardIteratorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetShardIteratorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getShardIteratorRequest).withMarshaller((Marshaller)new GetShardIteratorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public IncreaseStreamRetentionPeriodResponse increaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest increaseStreamRetentionPeriodRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new IncreaseStreamRetentionPeriodResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (IncreaseStreamRetentionPeriodResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)increaseStreamRetentionPeriodRequest).withMarshaller((Marshaller)new IncreaseStreamRetentionPeriodRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListShardsResponse listShards(ListShardsRequest listShardsRequest) throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, ExpiredNextTokenException, ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListShardsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListShardsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listShardsRequest).withMarshaller((Marshaller)new ListShardsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListStreamConsumersResponse listStreamConsumers(ListStreamConsumersRequest listStreamConsumersRequest) throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, ExpiredNextTokenException, ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStreamConsumersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListStreamConsumersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStreamConsumersRequest).withMarshaller((Marshaller)new ListStreamConsumersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListStreamConsumersIterable listStreamConsumersPaginator(ListStreamConsumersRequest listStreamConsumersRequest) throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, ExpiredNextTokenException, ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        return new ListStreamConsumersIterable(this, this.applyPaginatorUserAgent(listStreamConsumersRequest));
    }

    @Override
    public ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) throws LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStreamsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListStreamsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStreamsRequest).withMarshaller((Marshaller)new ListStreamsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTagsForStreamResponse listTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForStreamResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListTagsForStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForStreamRequest).withMarshaller((Marshaller)new ListTagsForStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public MergeShardsResponse mergeShards(MergeShardsRequest mergeShardsRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new MergeShardsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (MergeShardsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)mergeShardsRequest).withMarshaller((Marshaller)new MergeShardsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutRecordResponse putRecord(PutRecordRequest putRecordRequest) throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException, KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRecordResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (PutRecordResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putRecordRequest).withMarshaller((Marshaller)new PutRecordRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutRecordsResponse putRecords(PutRecordsRequest putRecordsRequest) throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException, KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRecordsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (PutRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putRecordsRequest).withMarshaller((Marshaller)new PutRecordsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RegisterStreamConsumerResponse registerStreamConsumer(RegisterStreamConsumerRequest registerStreamConsumerRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterStreamConsumerResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (RegisterStreamConsumerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerStreamConsumerRequest).withMarshaller((Marshaller)new RegisterStreamConsumerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemoveTagsFromStreamResponse removeTagsFromStream(RemoveTagsFromStreamRequest removeTagsFromStreamRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveTagsFromStreamResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (RemoveTagsFromStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsFromStreamRequest).withMarshaller((Marshaller)new RemoveTagsFromStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SplitShardResponse splitShard(SplitShardRequest splitShardRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SplitShardResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (SplitShardResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)splitShardRequest).withMarshaller((Marshaller)new SplitShardRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartStreamEncryptionResponse startStreamEncryption(StartStreamEncryptionRequest startStreamEncryptionRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartStreamEncryptionResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StartStreamEncryptionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startStreamEncryptionRequest).withMarshaller((Marshaller)new StartStreamEncryptionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StopStreamEncryptionResponse stopStreamEncryption(StopStreamEncryptionRequest stopStreamEncryptionRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopStreamEncryptionResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StopStreamEncryptionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopStreamEncryptionRequest).withMarshaller((Marshaller)new StopStreamEncryptionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateShardCountResponse updateShardCount(UpdateShardCountRequest updateShardCountRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateShardCountResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateShardCountResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateShardCountRequest).withMarshaller((Marshaller)new UpdateShardCountRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(KinesisException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSThrottlingException").withModeledClass(KmsThrottlingException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withModeledClass(InternalFailureException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArgumentException").withModeledClass(InvalidArgumentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSInvalidStateException").withModeledClass(KmsInvalidStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSNotFoundException").withModeledClass(KmsNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredIteratorException").withModeledClass(ExpiredIteratorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSOptInRequired").withModeledClass(KmsOptInRequiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSAccessDeniedException").withModeledClass(KmsAccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSDisabledException").withModeledClass(KmsDisabledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ProvisionedThroughputExceededException").withModeledClass(ProvisionedThroughputExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredNextTokenException").withModeledClass(ExpiredNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends KinesisRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-12").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((KinesisRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

