/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspacesstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesStreamsResponse;
import software.amazon.awssdk.services.keyspacesstreams.model.Record;
import software.amazon.awssdk.services.keyspacesstreams.model.RecordListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecordsResponse
extends KeyspacesStreamsResponse
implements ToCopyableBuilder<Builder, GetRecordsResponse> {
    private static final SdkField<List<Record>> CHANGE_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("changeRecords").getter(GetRecordsResponse.getter(GetRecordsResponse::changeRecords)).setter(GetRecordsResponse.setter(Builder::changeRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Record::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_SHARD_ITERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextShardIterator").getter(GetRecordsResponse.getter(GetRecordsResponse::nextShardIterator)).setter(GetRecordsResponse.setter(Builder::nextShardIterator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextShardIterator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_RECORDS_FIELD, NEXT_SHARD_ITERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRecordsResponse.memberNameToFieldInitializer();
    private final List<Record> changeRecords;
    private final String nextShardIterator;

    private GetRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.changeRecords = builder.changeRecords;
        this.nextShardIterator = builder.nextShardIterator;
    }

    public final boolean hasChangeRecords() {
        return this.changeRecords != null && !(this.changeRecords instanceof SdkAutoConstructList);
    }

    public final List<Record> changeRecords() {
        return this.changeRecords;
    }

    public final String nextShardIterator() {
        return this.nextShardIterator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChangeRecords() ? this.changeRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextShardIterator());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsResponse)) {
            return false;
        }
        GetRecordsResponse other = (GetRecordsResponse)((Object)obj);
        return this.hasChangeRecords() == other.hasChangeRecords() && Objects.equals(this.changeRecords(), other.changeRecords()) && Objects.equals(this.nextShardIterator(), other.nextShardIterator());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecordsResponse").add("ChangeRecords", this.hasChangeRecords() ? this.changeRecords() : null).add("NextShardIterator", (Object)this.nextShardIterator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "changeRecords": {
                return Optional.ofNullable(clazz.cast(this.changeRecords()));
            }
            case "nextShardIterator": {
                return Optional.ofNullable(clazz.cast(this.nextShardIterator()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("changeRecords", CHANGE_RECORDS_FIELD);
        map.put("nextShardIterator", NEXT_SHARD_ITERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecordsResponse, T> g) {
        return obj -> g.apply((GetRecordsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesStreamsResponse.BuilderImpl
    implements Builder {
        private List<Record> changeRecords = DefaultSdkAutoConstructList.getInstance();
        private String nextShardIterator;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordsResponse model) {
            super(model);
            this.changeRecords(model.changeRecords);
            this.nextShardIterator(model.nextShardIterator);
        }

        public final List<Record.Builder> getChangeRecords() {
            List<Record.Builder> result = RecordListCopier.copyToBuilder(this.changeRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeRecords(Collection<Record.BuilderImpl> changeRecords) {
            this.changeRecords = RecordListCopier.copyFromBuilder(changeRecords);
        }

        @Override
        public final Builder changeRecords(Collection<Record> changeRecords) {
            this.changeRecords = RecordListCopier.copy(changeRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeRecords(Record ... changeRecords) {
            this.changeRecords(Arrays.asList(changeRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeRecords(Consumer<Record.Builder> ... changeRecords) {
            this.changeRecords(Stream.of(changeRecords).map(c -> (Record)((Record.Builder)Record.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextShardIterator() {
            return this.nextShardIterator;
        }

        public final void setNextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
        }

        @Override
        public final Builder nextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
            return this;
        }

        @Override
        public GetRecordsResponse build() {
            return new GetRecordsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KeyspacesStreamsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecordsResponse> {
        public Builder changeRecords(Collection<Record> var1);

        public Builder changeRecords(Record ... var1);

        public Builder changeRecords(Consumer<Record.Builder> ... var1);

        public Builder nextShardIterator(String var1);
    }
}

