/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspacesstreams.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesStreamsResponse;
import software.amazon.awssdk.services.keyspacesstreams.model.Shard;
import software.amazon.awssdk.services.keyspacesstreams.model.ShardDescriptionListCopier;
import software.amazon.awssdk.services.keyspacesstreams.model.StreamStatus;
import software.amazon.awssdk.services.keyspacesstreams.model.StreamViewType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStreamResponse
extends KeyspacesStreamsResponse
implements ToCopyableBuilder<Builder, GetStreamResponse> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamArn").getter(GetStreamResponse.getter(GetStreamResponse::streamArn)).setter(GetStreamResponse.setter(Builder::streamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamArn").build()}).build();
    private static final SdkField<String> STREAM_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamLabel").getter(GetStreamResponse.getter(GetStreamResponse::streamLabel)).setter(GetStreamResponse.setter(Builder::streamLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamLabel").build()}).build();
    private static final SdkField<String> STREAM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamStatus").getter(GetStreamResponse.getter(GetStreamResponse::streamStatusAsString)).setter(GetStreamResponse.setter(Builder::streamStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamStatus").build()}).build();
    private static final SdkField<String> STREAM_VIEW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamViewType").getter(GetStreamResponse.getter(GetStreamResponse::streamViewTypeAsString)).setter(GetStreamResponse.setter(Builder::streamViewType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamViewType").build()}).build();
    private static final SdkField<Instant> CREATION_REQUEST_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationRequestDateTime").getter(GetStreamResponse.getter(GetStreamResponse::creationRequestDateTime)).setter(GetStreamResponse.setter(Builder::creationRequestDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationRequestDateTime").build()}).build();
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyspaceName").getter(GetStreamResponse.getter(GetStreamResponse::keyspaceName)).setter(GetStreamResponse.setter(Builder::keyspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableName").getter(GetStreamResponse.getter(GetStreamResponse::tableName)).setter(GetStreamResponse.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()}).build();
    private static final SdkField<List<Shard>> SHARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("shards").getter(GetStreamResponse.getter(GetStreamResponse::shards)).setter(GetStreamResponse.setter(Builder::shards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shards").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Shard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetStreamResponse.getter(GetStreamResponse::nextToken)).setter(GetStreamResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, STREAM_LABEL_FIELD, STREAM_STATUS_FIELD, STREAM_VIEW_TYPE_FIELD, CREATION_REQUEST_DATE_TIME_FIELD, KEYSPACE_NAME_FIELD, TABLE_NAME_FIELD, SHARDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetStreamResponse.memberNameToFieldInitializer();
    private final String streamArn;
    private final String streamLabel;
    private final String streamStatus;
    private final String streamViewType;
    private final Instant creationRequestDateTime;
    private final String keyspaceName;
    private final String tableName;
    private final List<Shard> shards;
    private final String nextToken;

    private GetStreamResponse(BuilderImpl builder) {
        super(builder);
        this.streamArn = builder.streamArn;
        this.streamLabel = builder.streamLabel;
        this.streamStatus = builder.streamStatus;
        this.streamViewType = builder.streamViewType;
        this.creationRequestDateTime = builder.creationRequestDateTime;
        this.keyspaceName = builder.keyspaceName;
        this.tableName = builder.tableName;
        this.shards = builder.shards;
        this.nextToken = builder.nextToken;
    }

    public final String streamArn() {
        return this.streamArn;
    }

    public final String streamLabel() {
        return this.streamLabel;
    }

    public final StreamStatus streamStatus() {
        return StreamStatus.fromValue(this.streamStatus);
    }

    public final String streamStatusAsString() {
        return this.streamStatus;
    }

    public final StreamViewType streamViewType() {
        return StreamViewType.fromValue(this.streamViewType);
    }

    public final String streamViewTypeAsString() {
        return this.streamViewType;
    }

    public final Instant creationRequestDateTime() {
        return this.creationRequestDateTime;
    }

    public final String keyspaceName() {
        return this.keyspaceName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasShards() {
        return this.shards != null && !(this.shards instanceof SdkAutoConstructList);
    }

    public final List<Shard> shards() {
        return this.shards;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamViewTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationRequestDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShards() ? this.shards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamResponse)) {
            return false;
        }
        GetStreamResponse other = (GetStreamResponse)((Object)obj);
        return Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.streamLabel(), other.streamLabel()) && Objects.equals(this.streamStatusAsString(), other.streamStatusAsString()) && Objects.equals(this.streamViewTypeAsString(), other.streamViewTypeAsString()) && Objects.equals(this.creationRequestDateTime(), other.creationRequestDateTime()) && Objects.equals(this.keyspaceName(), other.keyspaceName()) && Objects.equals(this.tableName(), other.tableName()) && this.hasShards() == other.hasShards() && Objects.equals(this.shards(), other.shards()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetStreamResponse").add("StreamArn", (Object)this.streamArn()).add("StreamLabel", (Object)this.streamLabel()).add("StreamStatus", (Object)this.streamStatusAsString()).add("StreamViewType", (Object)this.streamViewTypeAsString()).add("CreationRequestDateTime", (Object)this.creationRequestDateTime()).add("KeyspaceName", (Object)this.keyspaceName()).add("TableName", (Object)this.tableName()).add("Shards", this.hasShards() ? this.shards() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "streamLabel": {
                return Optional.ofNullable(clazz.cast(this.streamLabel()));
            }
            case "streamStatus": {
                return Optional.ofNullable(clazz.cast(this.streamStatusAsString()));
            }
            case "streamViewType": {
                return Optional.ofNullable(clazz.cast(this.streamViewTypeAsString()));
            }
            case "creationRequestDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationRequestDateTime()));
            }
            case "keyspaceName": {
                return Optional.ofNullable(clazz.cast(this.keyspaceName()));
            }
            case "tableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "shards": {
                return Optional.ofNullable(clazz.cast(this.shards()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("streamArn", STREAM_ARN_FIELD);
        map.put("streamLabel", STREAM_LABEL_FIELD);
        map.put("streamStatus", STREAM_STATUS_FIELD);
        map.put("streamViewType", STREAM_VIEW_TYPE_FIELD);
        map.put("creationRequestDateTime", CREATION_REQUEST_DATE_TIME_FIELD);
        map.put("keyspaceName", KEYSPACE_NAME_FIELD);
        map.put("tableName", TABLE_NAME_FIELD);
        map.put("shards", SHARDS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStreamResponse, T> g) {
        return obj -> g.apply((GetStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesStreamsResponse.BuilderImpl
    implements Builder {
        private String streamArn;
        private String streamLabel;
        private String streamStatus;
        private String streamViewType;
        private Instant creationRequestDateTime;
        private String keyspaceName;
        private String tableName;
        private List<Shard> shards = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamResponse model) {
            super(model);
            this.streamArn(model.streamArn);
            this.streamLabel(model.streamLabel);
            this.streamStatus(model.streamStatus);
            this.streamViewType(model.streamViewType);
            this.creationRequestDateTime(model.creationRequestDateTime);
            this.keyspaceName(model.keyspaceName);
            this.tableName(model.tableName);
            this.shards(model.shards);
            this.nextToken(model.nextToken);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getStreamLabel() {
            return this.streamLabel;
        }

        public final void setStreamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
        }

        @Override
        public final Builder streamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
            return this;
        }

        public final String getStreamStatus() {
            return this.streamStatus;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus == null ? null : streamStatus.toString());
            return this;
        }

        public final String getStreamViewType() {
            return this.streamViewType;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public final Builder streamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType == null ? null : streamViewType.toString());
            return this;
        }

        public final Instant getCreationRequestDateTime() {
            return this.creationRequestDateTime;
        }

        public final void setCreationRequestDateTime(Instant creationRequestDateTime) {
            this.creationRequestDateTime = creationRequestDateTime;
        }

        @Override
        public final Builder creationRequestDateTime(Instant creationRequestDateTime) {
            this.creationRequestDateTime = creationRequestDateTime;
            return this;
        }

        public final String getKeyspaceName() {
            return this.keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final List<Shard.Builder> getShards() {
            List<Shard.Builder> result = ShardDescriptionListCopier.copyToBuilder(this.shards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShards(Collection<Shard.BuilderImpl> shards) {
            this.shards = ShardDescriptionListCopier.copyFromBuilder(shards);
        }

        @Override
        public final Builder shards(Collection<Shard> shards) {
            this.shards = ShardDescriptionListCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Shard ... shards) {
            this.shards(Arrays.asList(shards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Consumer<Shard.Builder> ... shards) {
            this.shards(Stream.of(shards).map(c -> (Shard)((Shard.Builder)Shard.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetStreamResponse build() {
            return new GetStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KeyspacesStreamsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStreamResponse> {
        public Builder streamArn(String var1);

        public Builder streamLabel(String var1);

        public Builder streamStatus(String var1);

        public Builder streamStatus(StreamStatus var1);

        public Builder streamViewType(String var1);

        public Builder streamViewType(StreamViewType var1);

        public Builder creationRequestDateTime(Instant var1);

        public Builder keyspaceName(String var1);

        public Builder tableName(String var1);

        public Builder shards(Collection<Shard> var1);

        public Builder shards(Shard ... var1);

        public Builder shards(Consumer<Shard.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

