/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspacesstreams;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.keyspacesstreams.DefaultKeyspacesStreamsAsyncClientBuilder;
import software.amazon.awssdk.services.keyspacesstreams.KeyspacesStreamsAsyncClientBuilder;
import software.amazon.awssdk.services.keyspacesstreams.KeyspacesStreamsServiceClientConfiguration;
import software.amazon.awssdk.services.keyspacesstreams.model.GetRecordsRequest;
import software.amazon.awssdk.services.keyspacesstreams.model.GetRecordsResponse;
import software.amazon.awssdk.services.keyspacesstreams.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.keyspacesstreams.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.keyspacesstreams.model.GetStreamRequest;
import software.amazon.awssdk.services.keyspacesstreams.model.GetStreamResponse;
import software.amazon.awssdk.services.keyspacesstreams.model.ListStreamsRequest;
import software.amazon.awssdk.services.keyspacesstreams.model.ListStreamsResponse;
import software.amazon.awssdk.services.keyspacesstreams.paginators.GetStreamPublisher;
import software.amazon.awssdk.services.keyspacesstreams.paginators.ListStreamsPublisher;

@SdkPublicApi
@ThreadSafe
public interface KeyspacesStreamsAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "cassandra";
    public static final String SERVICE_METADATA_ID = "cassandra-streams";

    default public CompletableFuture<GetRecordsResponse> getRecords(GetRecordsRequest getRecordsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetRecordsResponse> getRecords(Consumer<GetRecordsRequest.Builder> getRecordsRequest) {
        return this.getRecords((GetRecordsRequest)((Object)((GetRecordsRequest.Builder)GetRecordsRequest.builder().applyMutation(getRecordsRequest)).build()));
    }

    default public CompletableFuture<GetShardIteratorResponse> getShardIterator(GetShardIteratorRequest getShardIteratorRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetShardIteratorResponse> getShardIterator(Consumer<GetShardIteratorRequest.Builder> getShardIteratorRequest) {
        return this.getShardIterator((GetShardIteratorRequest)((Object)((GetShardIteratorRequest.Builder)GetShardIteratorRequest.builder().applyMutation(getShardIteratorRequest)).build()));
    }

    default public CompletableFuture<GetStreamResponse> getStream(GetStreamRequest getStreamRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetStreamResponse> getStream(Consumer<GetStreamRequest.Builder> getStreamRequest) {
        return this.getStream((GetStreamRequest)((Object)((GetStreamRequest.Builder)GetStreamRequest.builder().applyMutation(getStreamRequest)).build()));
    }

    default public GetStreamPublisher getStreamPaginator(GetStreamRequest getStreamRequest) {
        return new GetStreamPublisher(this, getStreamRequest);
    }

    default public GetStreamPublisher getStreamPaginator(Consumer<GetStreamRequest.Builder> getStreamRequest) {
        return this.getStreamPaginator((GetStreamRequest)((Object)((GetStreamRequest.Builder)GetStreamRequest.builder().applyMutation(getStreamRequest)).build()));
    }

    default public CompletableFuture<ListStreamsResponse> listStreams(ListStreamsRequest listStreamsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListStreamsResponse> listStreams(Consumer<ListStreamsRequest.Builder> listStreamsRequest) {
        return this.listStreams((ListStreamsRequest)((Object)((ListStreamsRequest.Builder)ListStreamsRequest.builder().applyMutation(listStreamsRequest)).build()));
    }

    default public ListStreamsPublisher listStreamsPaginator(ListStreamsRequest listStreamsRequest) {
        return new ListStreamsPublisher(this, listStreamsRequest);
    }

    default public ListStreamsPublisher listStreamsPaginator(Consumer<ListStreamsRequest.Builder> listStreamsRequest) {
        return this.listStreamsPaginator((ListStreamsRequest)((Object)((ListStreamsRequest.Builder)ListStreamsRequest.builder().applyMutation(listStreamsRequest)).build()));
    }

    default public KeyspacesStreamsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static KeyspacesStreamsAsyncClient create() {
        return (KeyspacesStreamsAsyncClient)KeyspacesStreamsAsyncClient.builder().build();
    }

    public static KeyspacesStreamsAsyncClientBuilder builder() {
        return new DefaultKeyspacesStreamsAsyncClientBuilder();
    }
}

