/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspacesstreams.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ShardFilterType {
    CHILD_SHARDS("CHILD_SHARDS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ShardFilterType> VALUE_MAP;
    private final String value;

    private ShardFilterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ShardFilterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ShardFilterType> knownValues() {
        EnumSet<ShardFilterType> knownValues = EnumSet.allOf(ShardFilterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ShardFilterType.class, ShardFilterType::toString);
    }
}

