/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspacesstreams.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter used to limit the shards returned by a <code>GetStream</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShardFilter implements SdkPojo, Serializable, ToCopyableBuilder<ShardFilter.Builder, ShardFilter> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ShardFilter::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shardId").getter(getter(ShardFilter::shardId)).setter(setter(Builder::shardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SHARD_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String shardId;

    private ShardFilter(BuilderImpl builder) {
        this.type = builder.type;
        this.shardId = builder.shardId;
    }

    /**
     * <p>
     * The type of shard filter to use, which determines how the shardId parameter is interpreted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ShardFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of shard filter to use, which determines how the shardId parameter is interpreted.
     * @see ShardFilterType
     */
    public final ShardFilterType type() {
        return ShardFilterType.fromValue(type);
    }

    /**
     * <p>
     * The type of shard filter to use, which determines how the shardId parameter is interpreted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ShardFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of shard filter to use, which determines how the shardId parameter is interpreted.
     * @see ShardFilterType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The identifier of a specific shard used to filter results based on the specified filter type.
     * </p>
     * 
     * @return The identifier of a specific shard used to filter results based on the specified filter type.
     */
    public final String shardId() {
        return shardId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shardId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShardFilter)) {
            return false;
        }
        ShardFilter other = (ShardFilter) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(shardId(), other.shardId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShardFilter").add("Type", typeAsString()).add("ShardId", shardId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "shardId":
            return Optional.ofNullable(clazz.cast(shardId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("shardId", SHARD_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ShardFilter, T> g) {
        return obj -> g.apply((ShardFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShardFilter> {
        /**
         * <p>
         * The type of shard filter to use, which determines how the shardId parameter is interpreted.
         * </p>
         * 
         * @param type
         *        The type of shard filter to use, which determines how the shardId parameter is interpreted.
         * @see ShardFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardFilterType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of shard filter to use, which determines how the shardId parameter is interpreted.
         * </p>
         * 
         * @param type
         *        The type of shard filter to use, which determines how the shardId parameter is interpreted.
         * @see ShardFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardFilterType
         */
        Builder type(ShardFilterType type);

        /**
         * <p>
         * The identifier of a specific shard used to filter results based on the specified filter type.
         * </p>
         * 
         * @param shardId
         *        The identifier of a specific shard used to filter results based on the specified filter type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String shardId;

        private BuilderImpl() {
        }

        private BuilderImpl(ShardFilter model) {
            type(model.type);
            shardId(model.shardId);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ShardFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getShardId() {
            return shardId;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        @Override
        public ShardFilter build() {
            return new ShardFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
