/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspacesstreams.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetShardIteratorRequest extends KeyspacesStreamsRequest implements
        ToCopyableBuilder<GetShardIteratorRequest.Builder, GetShardIteratorRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamArn").getter(getter(GetShardIteratorRequest::streamArn)).setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamArn").build()).build();

    private static final SdkField<String> SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shardId").getter(getter(GetShardIteratorRequest::shardId)).setter(setter(Builder::shardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardId").build()).build();

    private static final SdkField<String> SHARD_ITERATOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shardIteratorType").getter(getter(GetShardIteratorRequest::shardIteratorTypeAsString))
            .setter(setter(Builder::shardIteratorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardIteratorType").build()).build();

    private static final SdkField<String> SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sequenceNumber").getter(getter(GetShardIteratorRequest::sequenceNumber))
            .setter(setter(Builder::sequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            SHARD_ID_FIELD, SHARD_ITERATOR_TYPE_FIELD, SEQUENCE_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamArn;

    private final String shardId;

    private final String shardIteratorType;

    private final String sequenceNumber;

    private GetShardIteratorRequest(BuilderImpl builder) {
        super(builder);
        this.streamArn = builder.streamArn;
        this.shardId = builder.shardId;
        this.shardIteratorType = builder.shardIteratorType;
        this.sequenceNumber = builder.sequenceNumber;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream for which to get the shard iterator. The ARN uniquely identifies the
     * stream within Amazon Keyspaces.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream for which to get the shard iterator. The ARN uniquely
     *         identifies the stream within Amazon Keyspaces.
     */
    public final String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The identifier of the shard within the stream. The shard ID uniquely identifies a subset of the stream's data
     * records that you want to access.
     * </p>
     * 
     * @return The identifier of the shard within the stream. The shard ID uniquely identifies a subset of the stream's
     *         data records that you want to access.
     */
    public final String shardId() {
        return shardId;
    }

    /**
     * <p>
     * Determines how the shard iterator is positioned. Must be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the shard, which is the oldest data
     * record in the shard.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the specified sequence number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the specified sequence number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LATEST</code> - Start reading just after the most recent record in the shard, so that you always read the
     * most recent data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shardIteratorType}
     * will return {@link ShardIteratorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shardIteratorTypeAsString}.
     * </p>
     * 
     * @return Determines how the shard iterator is positioned. Must be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the shard, which is the oldest
     *         data record in the shard.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the specified sequence number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the specified sequence number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LATEST</code> - Start reading just after the most recent record in the shard, so that you always
     *         read the most recent data.
     *         </p>
     *         </li>
     * @see ShardIteratorType
     */
    public final ShardIteratorType shardIteratorType() {
        return ShardIteratorType.fromValue(shardIteratorType);
    }

    /**
     * <p>
     * Determines how the shard iterator is positioned. Must be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the shard, which is the oldest data
     * record in the shard.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the specified sequence number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the specified sequence number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LATEST</code> - Start reading just after the most recent record in the shard, so that you always read the
     * most recent data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shardIteratorType}
     * will return {@link ShardIteratorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shardIteratorTypeAsString}.
     * </p>
     * 
     * @return Determines how the shard iterator is positioned. Must be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the shard, which is the oldest
     *         data record in the shard.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the specified sequence number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the specified sequence number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LATEST</code> - Start reading just after the most recent record in the shard, so that you always
     *         read the most recent data.
     *         </p>
     *         </li>
     * @see ShardIteratorType
     */
    public final String shardIteratorTypeAsString() {
        return shardIteratorType;
    }

    /**
     * <p>
     * The sequence number of the data record in the shard from which to start reading. Required if
     * <code>ShardIteratorType</code> is <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>. This
     * parameter is ignored for other iterator types.
     * </p>
     * 
     * @return The sequence number of the data record in the shard from which to start reading. Required if
     *         <code>ShardIteratorType</code> is <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>.
     *         This parameter is ignored for other iterator types.
     */
    public final String sequenceNumber() {
        return sequenceNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(shardId());
        hashCode = 31 * hashCode + Objects.hashCode(shardIteratorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetShardIteratorRequest)) {
            return false;
        }
        GetShardIteratorRequest other = (GetShardIteratorRequest) obj;
        return Objects.equals(streamArn(), other.streamArn()) && Objects.equals(shardId(), other.shardId())
                && Objects.equals(shardIteratorTypeAsString(), other.shardIteratorTypeAsString())
                && Objects.equals(sequenceNumber(), other.sequenceNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetShardIteratorRequest").add("StreamArn", streamArn()).add("ShardId", shardId())
                .add("ShardIteratorType", shardIteratorTypeAsString()).add("SequenceNumber", sequenceNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "shardId":
            return Optional.ofNullable(clazz.cast(shardId()));
        case "shardIteratorType":
            return Optional.ofNullable(clazz.cast(shardIteratorTypeAsString()));
        case "sequenceNumber":
            return Optional.ofNullable(clazz.cast(sequenceNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("streamArn", STREAM_ARN_FIELD);
        map.put("shardId", SHARD_ID_FIELD);
        map.put("shardIteratorType", SHARD_ITERATOR_TYPE_FIELD);
        map.put("sequenceNumber", SEQUENCE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetShardIteratorRequest, T> g) {
        return obj -> g.apply((GetShardIteratorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KeyspacesStreamsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetShardIteratorRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream for which to get the shard iterator. The ARN uniquely identifies
         * the stream within Amazon Keyspaces.
         * </p>
         * 
         * @param streamArn
         *        The Amazon Resource Name (ARN) of the stream for which to get the shard iterator. The ARN uniquely
         *        identifies the stream within Amazon Keyspaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The identifier of the shard within the stream. The shard ID uniquely identifies a subset of the stream's data
         * records that you want to access.
         * </p>
         * 
         * @param shardId
         *        The identifier of the shard within the stream. The shard ID uniquely identifies a subset of the
         *        stream's data records that you want to access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * <p>
         * Determines how the shard iterator is positioned. Must be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the shard, which is the oldest data
         * record in the shard.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the specified sequence number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the specified sequence number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LATEST</code> - Start reading just after the most recent record in the shard, so that you always read
         * the most recent data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shardIteratorType
         *        Determines how the shard iterator is positioned. Must be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the shard, which is the
         *        oldest data record in the shard.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the specified sequence number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the specified sequence number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LATEST</code> - Start reading just after the most recent record in the shard, so that you always
         *        read the most recent data.
         *        </p>
         *        </li>
         * @see ShardIteratorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardIteratorType
         */
        Builder shardIteratorType(String shardIteratorType);

        /**
         * <p>
         * Determines how the shard iterator is positioned. Must be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the shard, which is the oldest data
         * record in the shard.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the specified sequence number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the specified sequence number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LATEST</code> - Start reading just after the most recent record in the shard, so that you always read
         * the most recent data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shardIteratorType
         *        Determines how the shard iterator is positioned. Must be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the shard, which is the
         *        oldest data record in the shard.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the specified sequence number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the specified sequence number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LATEST</code> - Start reading just after the most recent record in the shard, so that you always
         *        read the most recent data.
         *        </p>
         *        </li>
         * @see ShardIteratorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardIteratorType
         */
        Builder shardIteratorType(ShardIteratorType shardIteratorType);

        /**
         * <p>
         * The sequence number of the data record in the shard from which to start reading. Required if
         * <code>ShardIteratorType</code> is <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>. This
         * parameter is ignored for other iterator types.
         * </p>
         * 
         * @param sequenceNumber
         *        The sequence number of the data record in the shard from which to start reading. Required if
         *        <code>ShardIteratorType</code> is <code>AT_SEQUENCE_NUMBER</code> or
         *        <code>AFTER_SEQUENCE_NUMBER</code>. This parameter is ignored for other iterator types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(String sequenceNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KeyspacesStreamsRequest.BuilderImpl implements Builder {
        private String streamArn;

        private String shardId;

        private String shardIteratorType;

        private String sequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetShardIteratorRequest model) {
            super(model);
            streamArn(model.streamArn);
            shardId(model.shardId);
            shardIteratorType(model.shardIteratorType);
            sequenceNumber(model.sequenceNumber);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getShardId() {
            return shardId;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final String getShardIteratorType() {
            return shardIteratorType;
        }

        public final void setShardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
        }

        @Override
        public final Builder shardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
            return this;
        }

        @Override
        public final Builder shardIteratorType(ShardIteratorType shardIteratorType) {
            this.shardIteratorType(shardIteratorType == null ? null : shardIteratorType.toString());
            return this;
        }

        public final String getSequenceNumber() {
            return sequenceNumber;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetShardIteratorRequest build() {
            return new GetShardIteratorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
