/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.keyspaces.model.AutoScalingSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicaSpecification> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(ReplicaSpecification.getter(ReplicaSpecification::region)).setter(ReplicaSpecification.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<Long> READ_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("readCapacityUnits").getter(ReplicaSpecification.getter(ReplicaSpecification::readCapacityUnits)).setter(ReplicaSpecification.setter(Builder::readCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readCapacityUnits").build()}).build();
    private static final SdkField<AutoScalingSettings> READ_CAPACITY_AUTO_SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("readCapacityAutoScaling").getter(ReplicaSpecification.getter(ReplicaSpecification::readCapacityAutoScaling)).setter(ReplicaSpecification.setter(Builder::readCapacityAutoScaling)).constructor(AutoScalingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readCapacityAutoScaling").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, READ_CAPACITY_UNITS_FIELD, READ_CAPACITY_AUTO_SCALING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplicaSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String region;
    private final Long readCapacityUnits;
    private final AutoScalingSettings readCapacityAutoScaling;

    private ReplicaSpecification(BuilderImpl builder) {
        this.region = builder.region;
        this.readCapacityUnits = builder.readCapacityUnits;
        this.readCapacityAutoScaling = builder.readCapacityAutoScaling;
    }

    public final String region() {
        return this.region;
    }

    public final Long readCapacityUnits() {
        return this.readCapacityUnits;
    }

    public final AutoScalingSettings readCapacityAutoScaling() {
        return this.readCapacityAutoScaling;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.readCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.readCapacityAutoScaling());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaSpecification)) {
            return false;
        }
        ReplicaSpecification other = (ReplicaSpecification)obj;
        return Objects.equals(this.region(), other.region()) && Objects.equals(this.readCapacityUnits(), other.readCapacityUnits()) && Objects.equals(this.readCapacityAutoScaling(), other.readCapacityAutoScaling());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicaSpecification").add("Region", (Object)this.region()).add("ReadCapacityUnits", (Object)this.readCapacityUnits()).add("ReadCapacityAutoScaling", (Object)this.readCapacityAutoScaling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "readCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.readCapacityUnits()));
            }
            case "readCapacityAutoScaling": {
                return Optional.ofNullable(clazz.cast(this.readCapacityAutoScaling()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("region", REGION_FIELD);
        map.put("readCapacityUnits", READ_CAPACITY_UNITS_FIELD);
        map.put("readCapacityAutoScaling", READ_CAPACITY_AUTO_SCALING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicaSpecification, T> g) {
        return obj -> g.apply((ReplicaSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private Long readCapacityUnits;
        private AutoScalingSettings readCapacityAutoScaling;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaSpecification model) {
            this.region(model.region);
            this.readCapacityUnits(model.readCapacityUnits);
            this.readCapacityAutoScaling(model.readCapacityAutoScaling);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Long getReadCapacityUnits() {
            return this.readCapacityUnits;
        }

        public final void setReadCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final AutoScalingSettings.Builder getReadCapacityAutoScaling() {
            return this.readCapacityAutoScaling != null ? this.readCapacityAutoScaling.toBuilder() : null;
        }

        public final void setReadCapacityAutoScaling(AutoScalingSettings.BuilderImpl readCapacityAutoScaling) {
            this.readCapacityAutoScaling = readCapacityAutoScaling != null ? readCapacityAutoScaling.build() : null;
        }

        @Override
        public final Builder readCapacityAutoScaling(AutoScalingSettings readCapacityAutoScaling) {
            this.readCapacityAutoScaling = readCapacityAutoScaling;
            return this;
        }

        public ReplicaSpecification build() {
            return new ReplicaSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicaSpecification> {
        public Builder region(String var1);

        public Builder readCapacityUnits(Long var1);

        public Builder readCapacityAutoScaling(AutoScalingSettings var1);

        default public Builder readCapacityAutoScaling(Consumer<AutoScalingSettings.Builder> readCapacityAutoScaling) {
            return this.readCapacityAutoScaling((AutoScalingSettings)((AutoScalingSettings.Builder)AutoScalingSettings.builder().applyMutation(readCapacityAutoScaling)).build());
        }
    }
}

