/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.keyspaces.model.KeyspacesResponse;
import software.amazon.awssdk.services.keyspaces.model.RegionListCopier;
import software.amazon.awssdk.services.keyspaces.model.Rs;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetKeyspaceResponse
extends KeyspacesResponse
implements ToCopyableBuilder<Builder, GetKeyspaceResponse> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyspaceName").getter(GetKeyspaceResponse.getter(GetKeyspaceResponse::keyspaceName)).setter(GetKeyspaceResponse.setter(Builder::keyspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(GetKeyspaceResponse.getter(GetKeyspaceResponse::resourceArn)).setter(GetKeyspaceResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> REPLICATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationStrategy").getter(GetKeyspaceResponse.getter(GetKeyspaceResponse::replicationStrategyAsString)).setter(GetKeyspaceResponse.setter(Builder::replicationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStrategy").build()}).build();
    private static final SdkField<List<String>> REPLICATION_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicationRegions").getter(GetKeyspaceResponse.getter(GetKeyspaceResponse::replicationRegions)).setter(GetKeyspaceResponse.setter(Builder::replicationRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD, RESOURCE_ARN_FIELD, REPLICATION_STRATEGY_FIELD, REPLICATION_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("keyspaceName", KEYSPACE_NAME_FIELD);
            this.put("resourceArn", RESOURCE_ARN_FIELD);
            this.put("replicationStrategy", REPLICATION_STRATEGY_FIELD);
            this.put("replicationRegions", REPLICATION_REGIONS_FIELD);
        }
    });
    private final String keyspaceName;
    private final String resourceArn;
    private final String replicationStrategy;
    private final List<String> replicationRegions;

    private GetKeyspaceResponse(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.resourceArn = builder.resourceArn;
        this.replicationStrategy = builder.replicationStrategy;
        this.replicationRegions = builder.replicationRegions;
    }

    public final String keyspaceName() {
        return this.keyspaceName;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Rs replicationStrategy() {
        return Rs.fromValue(this.replicationStrategy);
    }

    public final String replicationStrategyAsString() {
        return this.replicationStrategy;
    }

    public final boolean hasReplicationRegions() {
        return this.replicationRegions != null && !(this.replicationRegions instanceof SdkAutoConstructList);
    }

    public final List<String> replicationRegions() {
        return this.replicationRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationRegions() ? this.replicationRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyspaceResponse)) {
            return false;
        }
        GetKeyspaceResponse other = (GetKeyspaceResponse)((Object)obj);
        return Objects.equals(this.keyspaceName(), other.keyspaceName()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.replicationStrategyAsString(), other.replicationStrategyAsString()) && this.hasReplicationRegions() == other.hasReplicationRegions() && Objects.equals(this.replicationRegions(), other.replicationRegions());
    }

    public final String toString() {
        return ToString.builder((String)"GetKeyspaceResponse").add("KeyspaceName", (Object)this.keyspaceName()).add("ResourceArn", (Object)this.resourceArn()).add("ReplicationStrategy", (Object)this.replicationStrategyAsString()).add("ReplicationRegions", this.hasReplicationRegions() ? this.replicationRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyspaceName": {
                return Optional.ofNullable(clazz.cast(this.keyspaceName()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "replicationStrategy": {
                return Optional.ofNullable(clazz.cast(this.replicationStrategyAsString()));
            }
            case "replicationRegions": {
                return Optional.ofNullable(clazz.cast(this.replicationRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetKeyspaceResponse, T> g) {
        return obj -> g.apply((GetKeyspaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesResponse.BuilderImpl
    implements Builder {
        private String keyspaceName;
        private String resourceArn;
        private String replicationStrategy;
        private List<String> replicationRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyspaceResponse model) {
            super(model);
            this.keyspaceName(model.keyspaceName);
            this.resourceArn(model.resourceArn);
            this.replicationStrategy(model.replicationStrategy);
            this.replicationRegions(model.replicationRegions);
        }

        public final String getKeyspaceName() {
            return this.keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getReplicationStrategy() {
            return this.replicationStrategy;
        }

        public final void setReplicationStrategy(String replicationStrategy) {
            this.replicationStrategy = replicationStrategy;
        }

        @Override
        public final Builder replicationStrategy(String replicationStrategy) {
            this.replicationStrategy = replicationStrategy;
            return this;
        }

        @Override
        public final Builder replicationStrategy(Rs replicationStrategy) {
            this.replicationStrategy(replicationStrategy == null ? null : replicationStrategy.toString());
            return this;
        }

        public final Collection<String> getReplicationRegions() {
            if (this.replicationRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationRegions;
        }

        public final void setReplicationRegions(Collection<String> replicationRegions) {
            this.replicationRegions = RegionListCopier.copy(replicationRegions);
        }

        @Override
        public final Builder replicationRegions(Collection<String> replicationRegions) {
            this.replicationRegions = RegionListCopier.copy(replicationRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRegions(String ... replicationRegions) {
            this.replicationRegions(Arrays.asList(replicationRegions));
            return this;
        }

        @Override
        public GetKeyspaceResponse build() {
            return new GetKeyspaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KeyspacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetKeyspaceResponse> {
        public Builder keyspaceName(String var1);

        public Builder resourceArn(String var1);

        public Builder replicationStrategy(String var1);

        public Builder replicationStrategy(Rs var1);

        public Builder replicationRegions(Collection<String> var1);

        public Builder replicationRegions(String ... var1);
    }
}

