/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.keyspaces.DefaultKeyspacesAsyncClient;
import software.amazon.awssdk.services.keyspaces.DefaultKeyspacesBaseClientBuilder;
import software.amazon.awssdk.services.keyspaces.KeyspacesAsyncClient;
import software.amazon.awssdk.services.keyspaces.KeyspacesAsyncClientBuilder;
import software.amazon.awssdk.services.keyspaces.KeyspacesServiceClientConfiguration;
import software.amazon.awssdk.services.keyspaces.endpoints.KeyspacesEndpointProvider;

@SdkInternalApi
final class DefaultKeyspacesAsyncClientBuilder
extends DefaultKeyspacesBaseClientBuilder<KeyspacesAsyncClientBuilder, KeyspacesAsyncClient>
implements KeyspacesAsyncClientBuilder {
    DefaultKeyspacesAsyncClientBuilder() {
    }

    @Override
    public DefaultKeyspacesAsyncClientBuilder endpointProvider(KeyspacesEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KeyspacesAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultKeyspacesAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        KeyspacesServiceClientConfiguration serviceClientConfiguration = KeyspacesServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultKeyspacesAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

