/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.keyspaces.DefaultKeyspacesClientBuilder;
import software.amazon.awssdk.services.keyspaces.KeyspacesClientBuilder;
import software.amazon.awssdk.services.keyspaces.model.AccessDeniedException;
import software.amazon.awssdk.services.keyspaces.model.ConflictException;
import software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceRequest;
import software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceResponse;
import software.amazon.awssdk.services.keyspaces.model.CreateTableRequest;
import software.amazon.awssdk.services.keyspaces.model.CreateTableResponse;
import software.amazon.awssdk.services.keyspaces.model.DeleteKeyspaceRequest;
import software.amazon.awssdk.services.keyspaces.model.DeleteKeyspaceResponse;
import software.amazon.awssdk.services.keyspaces.model.DeleteTableRequest;
import software.amazon.awssdk.services.keyspaces.model.DeleteTableResponse;
import software.amazon.awssdk.services.keyspaces.model.GetKeyspaceRequest;
import software.amazon.awssdk.services.keyspaces.model.GetKeyspaceResponse;
import software.amazon.awssdk.services.keyspaces.model.GetTableRequest;
import software.amazon.awssdk.services.keyspaces.model.GetTableResponse;
import software.amazon.awssdk.services.keyspaces.model.InternalServerException;
import software.amazon.awssdk.services.keyspaces.model.KeyspacesException;
import software.amazon.awssdk.services.keyspaces.model.ListKeyspacesRequest;
import software.amazon.awssdk.services.keyspaces.model.ListKeyspacesResponse;
import software.amazon.awssdk.services.keyspaces.model.ListTablesRequest;
import software.amazon.awssdk.services.keyspaces.model.ListTablesResponse;
import software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.keyspaces.model.ResourceNotFoundException;
import software.amazon.awssdk.services.keyspaces.model.RestoreTableRequest;
import software.amazon.awssdk.services.keyspaces.model.RestoreTableResponse;
import software.amazon.awssdk.services.keyspaces.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.keyspaces.model.TagResourceRequest;
import software.amazon.awssdk.services.keyspaces.model.TagResourceResponse;
import software.amazon.awssdk.services.keyspaces.model.UntagResourceRequest;
import software.amazon.awssdk.services.keyspaces.model.UntagResourceResponse;
import software.amazon.awssdk.services.keyspaces.model.UpdateTableRequest;
import software.amazon.awssdk.services.keyspaces.model.UpdateTableResponse;
import software.amazon.awssdk.services.keyspaces.model.ValidationException;
import software.amazon.awssdk.services.keyspaces.paginators.ListKeyspacesIterable;
import software.amazon.awssdk.services.keyspaces.paginators.ListTablesIterable;
import software.amazon.awssdk.services.keyspaces.paginators.ListTagsForResourceIterable;

@SdkPublicApi
@ThreadSafe
public interface KeyspacesClient
extends SdkClient {
    public static final String SERVICE_NAME = "cassandra";
    public static final String SERVICE_METADATA_ID = "cassandra";

    default public CreateKeyspaceResponse createKeyspace(CreateKeyspaceRequest createKeyspaceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public CreateKeyspaceResponse createKeyspace(Consumer<CreateKeyspaceRequest.Builder> createKeyspaceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.createKeyspace((CreateKeyspaceRequest)((Object)((CreateKeyspaceRequest.Builder)CreateKeyspaceRequest.builder().applyMutation(createKeyspaceRequest)).build()));
    }

    default public CreateTableResponse createTable(CreateTableRequest createTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public CreateTableResponse createTable(Consumer<CreateTableRequest.Builder> createTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.createTable((CreateTableRequest)((Object)((CreateTableRequest.Builder)CreateTableRequest.builder().applyMutation(createTableRequest)).build()));
    }

    default public DeleteKeyspaceResponse deleteKeyspace(DeleteKeyspaceRequest deleteKeyspaceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public DeleteKeyspaceResponse deleteKeyspace(Consumer<DeleteKeyspaceRequest.Builder> deleteKeyspaceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.deleteKeyspace((DeleteKeyspaceRequest)((Object)((DeleteKeyspaceRequest.Builder)DeleteKeyspaceRequest.builder().applyMutation(deleteKeyspaceRequest)).build()));
    }

    default public DeleteTableResponse deleteTable(DeleteTableRequest deleteTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public DeleteTableResponse deleteTable(Consumer<DeleteTableRequest.Builder> deleteTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.deleteTable((DeleteTableRequest)((Object)((DeleteTableRequest.Builder)DeleteTableRequest.builder().applyMutation(deleteTableRequest)).build()));
    }

    default public GetKeyspaceResponse getKeyspace(GetKeyspaceRequest getKeyspaceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public GetKeyspaceResponse getKeyspace(Consumer<GetKeyspaceRequest.Builder> getKeyspaceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.getKeyspace((GetKeyspaceRequest)((Object)((GetKeyspaceRequest.Builder)GetKeyspaceRequest.builder().applyMutation(getKeyspaceRequest)).build()));
    }

    default public GetTableResponse getTable(GetTableRequest getTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public GetTableResponse getTable(Consumer<GetTableRequest.Builder> getTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.getTable((GetTableRequest)((Object)((GetTableRequest.Builder)GetTableRequest.builder().applyMutation(getTableRequest)).build()));
    }

    default public ListKeyspacesResponse listKeyspaces(ListKeyspacesRequest listKeyspacesRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public ListKeyspacesResponse listKeyspaces(Consumer<ListKeyspacesRequest.Builder> listKeyspacesRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.listKeyspaces((ListKeyspacesRequest)((Object)((ListKeyspacesRequest.Builder)ListKeyspacesRequest.builder().applyMutation(listKeyspacesRequest)).build()));
    }

    default public ListKeyspacesIterable listKeyspacesPaginator(ListKeyspacesRequest listKeyspacesRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public ListKeyspacesIterable listKeyspacesPaginator(Consumer<ListKeyspacesRequest.Builder> listKeyspacesRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.listKeyspacesPaginator((ListKeyspacesRequest)((Object)((ListKeyspacesRequest.Builder)ListKeyspacesRequest.builder().applyMutation(listKeyspacesRequest)).build()));
    }

    default public ListTablesResponse listTables(ListTablesRequest listTablesRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public ListTablesResponse listTables(Consumer<ListTablesRequest.Builder> listTablesRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.listTables((ListTablesRequest)((Object)((ListTablesRequest.Builder)ListTablesRequest.builder().applyMutation(listTablesRequest)).build()));
    }

    default public ListTablesIterable listTablesPaginator(ListTablesRequest listTablesRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public ListTablesIterable listTablesPaginator(Consumer<ListTablesRequest.Builder> listTablesRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.listTablesPaginator((ListTablesRequest)((Object)((ListTablesRequest.Builder)ListTablesRequest.builder().applyMutation(listTablesRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceIterable listTagsForResourcePaginator(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.listTagsForResourcePaginator((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public RestoreTableResponse restoreTable(RestoreTableRequest restoreTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public RestoreTableResponse restoreTable(Consumer<RestoreTableRequest.Builder> restoreTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.restoreTable((RestoreTableRequest)((Object)((RestoreTableRequest.Builder)RestoreTableRequest.builder().applyMutation(restoreTableRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateTableResponse updateTable(UpdateTableRequest updateTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        throw new UnsupportedOperationException();
    }

    default public UpdateTableResponse updateTable(Consumer<UpdateTableRequest.Builder> updateTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        return this.updateTable((UpdateTableRequest)((Object)((UpdateTableRequest.Builder)UpdateTableRequest.builder().applyMutation(updateTableRequest)).build()));
    }

    public static KeyspacesClient create() {
        return (KeyspacesClient)KeyspacesClient.builder().build();
    }

    public static KeyspacesClientBuilder builder() {
        return new DefaultKeyspacesClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"cassandra");
    }
}

