/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.keyspaces.model.ThroughputMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacitySpecificationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacitySpecificationSummary> {
    private static final SdkField<String> THROUGHPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("throughputMode").getter(CapacitySpecificationSummary.getter(CapacitySpecificationSummary::throughputModeAsString)).setter(CapacitySpecificationSummary.setter(Builder::throughputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throughputMode").build()}).build();
    private static final SdkField<Long> READ_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("readCapacityUnits").getter(CapacitySpecificationSummary.getter(CapacitySpecificationSummary::readCapacityUnits)).setter(CapacitySpecificationSummary.setter(Builder::readCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readCapacityUnits").build()}).build();
    private static final SdkField<Long> WRITE_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("writeCapacityUnits").getter(CapacitySpecificationSummary.getter(CapacitySpecificationSummary::writeCapacityUnits)).setter(CapacitySpecificationSummary.setter(Builder::writeCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeCapacityUnits").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TO_PAY_PER_REQUEST_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateToPayPerRequestTimestamp").getter(CapacitySpecificationSummary.getter(CapacitySpecificationSummary::lastUpdateToPayPerRequestTimestamp)).setter(CapacitySpecificationSummary.setter(Builder::lastUpdateToPayPerRequestTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateToPayPerRequestTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THROUGHPUT_MODE_FIELD, READ_CAPACITY_UNITS_FIELD, WRITE_CAPACITY_UNITS_FIELD, LAST_UPDATE_TO_PAY_PER_REQUEST_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String throughputMode;
    private final Long readCapacityUnits;
    private final Long writeCapacityUnits;
    private final Instant lastUpdateToPayPerRequestTimestamp;

    private CapacitySpecificationSummary(BuilderImpl builder) {
        this.throughputMode = builder.throughputMode;
        this.readCapacityUnits = builder.readCapacityUnits;
        this.writeCapacityUnits = builder.writeCapacityUnits;
        this.lastUpdateToPayPerRequestTimestamp = builder.lastUpdateToPayPerRequestTimestamp;
    }

    public final ThroughputMode throughputMode() {
        return ThroughputMode.fromValue(this.throughputMode);
    }

    public final String throughputModeAsString() {
        return this.throughputMode;
    }

    public final Long readCapacityUnits() {
        return this.readCapacityUnits;
    }

    public final Long writeCapacityUnits() {
        return this.writeCapacityUnits;
    }

    public final Instant lastUpdateToPayPerRequestTimestamp() {
        return this.lastUpdateToPayPerRequestTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.readCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateToPayPerRequestTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacitySpecificationSummary)) {
            return false;
        }
        CapacitySpecificationSummary other = (CapacitySpecificationSummary)obj;
        return Objects.equals(this.throughputModeAsString(), other.throughputModeAsString()) && Objects.equals(this.readCapacityUnits(), other.readCapacityUnits()) && Objects.equals(this.writeCapacityUnits(), other.writeCapacityUnits()) && Objects.equals(this.lastUpdateToPayPerRequestTimestamp(), other.lastUpdateToPayPerRequestTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"CapacitySpecificationSummary").add("ThroughputMode", (Object)this.throughputModeAsString()).add("ReadCapacityUnits", (Object)this.readCapacityUnits()).add("WriteCapacityUnits", (Object)this.writeCapacityUnits()).add("LastUpdateToPayPerRequestTimestamp", (Object)this.lastUpdateToPayPerRequestTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "throughputMode": {
                return Optional.ofNullable(clazz.cast(this.throughputModeAsString()));
            }
            case "readCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.readCapacityUnits()));
            }
            case "writeCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.writeCapacityUnits()));
            }
            case "lastUpdateToPayPerRequestTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateToPayPerRequestTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacitySpecificationSummary, T> g) {
        return obj -> g.apply((CapacitySpecificationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String throughputMode;
        private Long readCapacityUnits;
        private Long writeCapacityUnits;
        private Instant lastUpdateToPayPerRequestTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacitySpecificationSummary model) {
            this.throughputMode(model.throughputMode);
            this.readCapacityUnits(model.readCapacityUnits);
            this.writeCapacityUnits(model.writeCapacityUnits);
            this.lastUpdateToPayPerRequestTimestamp(model.lastUpdateToPayPerRequestTimestamp);
        }

        public final String getThroughputMode() {
            return this.throughputMode;
        }

        public final void setThroughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
        }

        @Override
        @Transient
        public final Builder throughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        @Override
        @Transient
        public final Builder throughputMode(ThroughputMode throughputMode) {
            this.throughputMode(throughputMode == null ? null : throughputMode.toString());
            return this;
        }

        public final Long getReadCapacityUnits() {
            return this.readCapacityUnits;
        }

        public final void setReadCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        @Override
        @Transient
        public final Builder readCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final Long getWriteCapacityUnits() {
            return this.writeCapacityUnits;
        }

        public final void setWriteCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
        }

        @Override
        @Transient
        public final Builder writeCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        public final Instant getLastUpdateToPayPerRequestTimestamp() {
            return this.lastUpdateToPayPerRequestTimestamp;
        }

        public final void setLastUpdateToPayPerRequestTimestamp(Instant lastUpdateToPayPerRequestTimestamp) {
            this.lastUpdateToPayPerRequestTimestamp = lastUpdateToPayPerRequestTimestamp;
        }

        @Override
        @Transient
        public final Builder lastUpdateToPayPerRequestTimestamp(Instant lastUpdateToPayPerRequestTimestamp) {
            this.lastUpdateToPayPerRequestTimestamp = lastUpdateToPayPerRequestTimestamp;
            return this;
        }

        public CapacitySpecificationSummary build() {
            return new CapacitySpecificationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacitySpecificationSummary> {
        public Builder throughputMode(String var1);

        public Builder throughputMode(ThroughputMode var1);

        public Builder readCapacityUnits(Long var1);

        public Builder writeCapacityUnits(Long var1);

        public Builder lastUpdateToPayPerRequestTimestamp(Instant var1);
    }
}

