/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendraranking.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendraranking.model.BodyTokensListCopier;
import software.amazon.awssdk.services.kendraranking.model.TitleTokensListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Document
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Document> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Document.getter(Document::id)).setter(Document.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(Document.getter(Document::groupId)).setter(Document.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(Document.getter(Document::title)).setter(Document.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(Document.getter(Document::body)).setter(Document.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<List<String>> TOKENIZED_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TokenizedTitle").getter(Document.getter(Document::tokenizedTitle)).setter(Document.setter(Builder::tokenizedTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenizedTitle").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TOKENIZED_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TokenizedBody").getter(Document.getter(Document::tokenizedBody)).setter(Document.setter(Builder::tokenizedBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenizedBody").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> ORIGINAL_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("OriginalScore").getter(Document.getter(Document::originalScore)).setter(Document.setter(Builder::originalScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalScore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, GROUP_ID_FIELD, TITLE_FIELD, BODY_FIELD, TOKENIZED_TITLE_FIELD, TOKENIZED_BODY_FIELD, ORIGINAL_SCORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String groupId;
    private final String title;
    private final String body;
    private final List<String> tokenizedTitle;
    private final List<String> tokenizedBody;
    private final Float originalScore;

    private Document(BuilderImpl builder) {
        this.id = builder.id;
        this.groupId = builder.groupId;
        this.title = builder.title;
        this.body = builder.body;
        this.tokenizedTitle = builder.tokenizedTitle;
        this.tokenizedBody = builder.tokenizedBody;
        this.originalScore = builder.originalScore;
    }

    public final String id() {
        return this.id;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String title() {
        return this.title;
    }

    public final String body() {
        return this.body;
    }

    public final boolean hasTokenizedTitle() {
        return this.tokenizedTitle != null && !(this.tokenizedTitle instanceof SdkAutoConstructList);
    }

    public final List<String> tokenizedTitle() {
        return this.tokenizedTitle;
    }

    public final boolean hasTokenizedBody() {
        return this.tokenizedBody != null && !(this.tokenizedBody instanceof SdkAutoConstructList);
    }

    public final List<String> tokenizedBody() {
        return this.tokenizedBody;
    }

    public final Float originalScore() {
        return this.originalScore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenizedTitle() ? this.tokenizedTitle() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenizedBody() ? this.tokenizedBody() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.originalScore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Document)) {
            return false;
        }
        Document other = (Document)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.body(), other.body()) && this.hasTokenizedTitle() == other.hasTokenizedTitle() && Objects.equals(this.tokenizedTitle(), other.tokenizedTitle()) && this.hasTokenizedBody() == other.hasTokenizedBody() && Objects.equals(this.tokenizedBody(), other.tokenizedBody()) && Objects.equals(this.originalScore(), other.originalScore());
    }

    public final String toString() {
        return ToString.builder((String)"Document").add("Id", (Object)this.id()).add("GroupId", (Object)this.groupId()).add("Title", (Object)this.title()).add("Body", (Object)this.body()).add("TokenizedTitle", this.hasTokenizedTitle() ? this.tokenizedTitle() : null).add("TokenizedBody", this.hasTokenizedBody() ? this.tokenizedBody() : null).add("OriginalScore", (Object)this.originalScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "TokenizedTitle": {
                return Optional.ofNullable(clazz.cast(this.tokenizedTitle()));
            }
            case "TokenizedBody": {
                return Optional.ofNullable(clazz.cast(this.tokenizedBody()));
            }
            case "OriginalScore": {
                return Optional.ofNullable(clazz.cast(this.originalScore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Document, T> g) {
        return obj -> g.apply((Document)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String groupId;
        private String title;
        private String body;
        private List<String> tokenizedTitle = DefaultSdkAutoConstructList.getInstance();
        private List<String> tokenizedBody = DefaultSdkAutoConstructList.getInstance();
        private Float originalScore;

        private BuilderImpl() {
        }

        private BuilderImpl(Document model) {
            this.id(model.id);
            this.groupId(model.groupId);
            this.title(model.title);
            this.body(model.body);
            this.tokenizedTitle(model.tokenizedTitle);
            this.tokenizedBody(model.tokenizedBody);
            this.originalScore(model.originalScore);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final Collection<String> getTokenizedTitle() {
            if (this.tokenizedTitle instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tokenizedTitle;
        }

        public final void setTokenizedTitle(Collection<String> tokenizedTitle) {
            this.tokenizedTitle = TitleTokensListCopier.copy(tokenizedTitle);
        }

        @Override
        public final Builder tokenizedTitle(Collection<String> tokenizedTitle) {
            this.tokenizedTitle = TitleTokensListCopier.copy(tokenizedTitle);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenizedTitle(String ... tokenizedTitle) {
            this.tokenizedTitle(Arrays.asList(tokenizedTitle));
            return this;
        }

        public final Collection<String> getTokenizedBody() {
            if (this.tokenizedBody instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tokenizedBody;
        }

        public final void setTokenizedBody(Collection<String> tokenizedBody) {
            this.tokenizedBody = BodyTokensListCopier.copy(tokenizedBody);
        }

        @Override
        public final Builder tokenizedBody(Collection<String> tokenizedBody) {
            this.tokenizedBody = BodyTokensListCopier.copy(tokenizedBody);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenizedBody(String ... tokenizedBody) {
            this.tokenizedBody(Arrays.asList(tokenizedBody));
            return this;
        }

        public final Float getOriginalScore() {
            return this.originalScore;
        }

        public final void setOriginalScore(Float originalScore) {
            this.originalScore = originalScore;
        }

        @Override
        public final Builder originalScore(Float originalScore) {
            this.originalScore = originalScore;
            return this;
        }

        public Document build() {
            return new Document(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Document> {
        public Builder id(String var1);

        public Builder groupId(String var1);

        public Builder title(String var1);

        public Builder body(String var1);

        public Builder tokenizedTitle(Collection<String> var1);

        public Builder tokenizedTitle(String ... var1);

        public Builder tokenizedBody(Collection<String> var1);

        public Builder tokenizedBody(String ... var1);

        public Builder originalScore(Float var1);
    }
}

