/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendraranking.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.kendraranking.endpoints.KendraRankingEndpointParams;
import software.amazon.awssdk.services.kendraranking.endpoints.KendraRankingEndpointProvider;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.Condition;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.Expr;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.FnNode;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.Identifier;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.Parameter;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.Parameters;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.Rule;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public final class DefaultKendraRankingEndpointProvider
implements KendraRankingEndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultKendraRankingEndpointProvider.ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(KendraRankingEndpointParams endpointParams) {
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultKendraRankingEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(KendraRankingEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_2() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: FIPS and custom endpoint are not supported");
    }

    private static Rule endpointRule_3() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).treeRule(Arrays.asList(DefaultKendraRankingEndpointProvider.endpointRule_2(), DefaultKendraRankingEndpointProvider.endpointRule_3()));
    }

    private static Rule endpointRule_8() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://kendra-ranking-fips.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultKendraRankingEndpointProvider.endpointRule_8()));
    }

    private static Rule endpointRule_9() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultKendraRankingEndpointProvider.endpointRule_7(), DefaultKendraRankingEndpointProvider.endpointRule_9()));
    }

    private static Rule endpointRule_10() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://kendra-ranking.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_5() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultKendraRankingEndpointProvider.endpointRule_6(), DefaultKendraRankingEndpointProvider.endpointRule_10()));
    }

    private static Rule endpointRule_14() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://kendra-ranking-fips.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_13() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultKendraRankingEndpointProvider.endpointRule_14()));
    }

    private static Rule endpointRule_15() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_12() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultKendraRankingEndpointProvider.endpointRule_13(), DefaultKendraRankingEndpointProvider.endpointRule_15()));
    }

    private static Rule endpointRule_16() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://kendra-ranking.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_11() {
        return Rule.builder().treeRule(Arrays.asList(DefaultKendraRankingEndpointProvider.endpointRule_12(), DefaultKendraRankingEndpointProvider.endpointRule_16()));
    }

    private static Rule endpointRule_4() {
        return Rule.builder().treeRule(Arrays.asList(DefaultKendraRankingEndpointProvider.endpointRule_5(), DefaultKendraRankingEndpointProvider.endpointRule_11()));
    }

    private static Rule endpointRule_0() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("PartitionResult").build()).treeRule(Arrays.asList(DefaultKendraRankingEndpointProvider.endpointRule_1(), DefaultKendraRankingEndpointProvider.endpointRule_4()));
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(true).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).build()).addRule(DefaultKendraRankingEndpointProvider.endpointRule_0()).build();
    }
}

