/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.AttributeFilter;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeKeyListCopier;
import software.amazon.awssdk.services.kendra.model.DocumentRelevanceConfiguration;
import software.amazon.awssdk.services.kendra.model.DocumentRelevanceOverrideConfigurationListCopier;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.services.kendra.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieveRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, RetrieveRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(RetrieveRequest.getter(RetrieveRequest::indexId)).setter(RetrieveRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryText").getter(RetrieveRequest.getter(RetrieveRequest::queryText)).setter(RetrieveRequest.setter(Builder::queryText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()}).build();
    private static final SdkField<AttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttributeFilter").getter(RetrieveRequest.getter(RetrieveRequest::attributeFilter)).setter(RetrieveRequest.setter(Builder::attributeFilter)).constructor(AttributeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilter").build()}).build();
    private static final SdkField<List<String>> REQUESTED_DOCUMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequestedDocumentAttributes").getter(RetrieveRequest.getter(RetrieveRequest::requestedDocumentAttributes)).setter(RetrieveRequest.setter(Builder::requestedDocumentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedDocumentAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DocumentRelevanceConfiguration>> DOCUMENT_RELEVANCE_OVERRIDE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentRelevanceOverrideConfigurations").getter(RetrieveRequest.getter(RetrieveRequest::documentRelevanceOverrideConfigurations)).setter(RetrieveRequest.setter(Builder::documentRelevanceOverrideConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentRelevanceOverrideConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentRelevanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PAGE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageNumber").getter(RetrieveRequest.getter(RetrieveRequest::pageNumber)).setter(RetrieveRequest.setter(Builder::pageNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageNumber").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(RetrieveRequest.getter(RetrieveRequest::pageSize)).setter(RetrieveRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<UserContext> USER_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserContext").getter(RetrieveRequest.getter(RetrieveRequest::userContext)).setter(RetrieveRequest.setter(Builder::userContext)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, QUERY_TEXT_FIELD, ATTRIBUTE_FILTER_FIELD, REQUESTED_DOCUMENT_ATTRIBUTES_FIELD, DOCUMENT_RELEVANCE_OVERRIDE_CONFIGURATIONS_FIELD, PAGE_NUMBER_FIELD, PAGE_SIZE_FIELD, USER_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetrieveRequest.memberNameToFieldInitializer();
    private final String indexId;
    private final String queryText;
    private final AttributeFilter attributeFilter;
    private final List<String> requestedDocumentAttributes;
    private final List<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations;
    private final Integer pageNumber;
    private final Integer pageSize;
    private final UserContext userContext;

    private RetrieveRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.queryText = builder.queryText;
        this.attributeFilter = builder.attributeFilter;
        this.requestedDocumentAttributes = builder.requestedDocumentAttributes;
        this.documentRelevanceOverrideConfigurations = builder.documentRelevanceOverrideConfigurations;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.userContext = builder.userContext;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String queryText() {
        return this.queryText;
    }

    public final AttributeFilter attributeFilter() {
        return this.attributeFilter;
    }

    public final boolean hasRequestedDocumentAttributes() {
        return this.requestedDocumentAttributes != null && !(this.requestedDocumentAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> requestedDocumentAttributes() {
        return this.requestedDocumentAttributes;
    }

    public final boolean hasDocumentRelevanceOverrideConfigurations() {
        return this.documentRelevanceOverrideConfigurations != null && !(this.documentRelevanceOverrideConfigurations instanceof SdkAutoConstructList);
    }

    public final List<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations() {
        return this.documentRelevanceOverrideConfigurations;
    }

    public final Integer pageNumber() {
        return this.pageNumber;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    public final UserContext userContext() {
        return this.userContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryText());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestedDocumentAttributes() ? this.requestedDocumentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentRelevanceOverrideConfigurations() ? this.documentRelevanceOverrideConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pageNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.userContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveRequest)) {
            return false;
        }
        RetrieveRequest other = (RetrieveRequest)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.queryText(), other.queryText()) && Objects.equals(this.attributeFilter(), other.attributeFilter()) && this.hasRequestedDocumentAttributes() == other.hasRequestedDocumentAttributes() && Objects.equals(this.requestedDocumentAttributes(), other.requestedDocumentAttributes()) && this.hasDocumentRelevanceOverrideConfigurations() == other.hasDocumentRelevanceOverrideConfigurations() && Objects.equals(this.documentRelevanceOverrideConfigurations(), other.documentRelevanceOverrideConfigurations()) && Objects.equals(this.pageNumber(), other.pageNumber()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.userContext(), other.userContext());
    }

    public final String toString() {
        return ToString.builder((String)"RetrieveRequest").add("IndexId", (Object)this.indexId()).add("QueryText", (Object)this.queryText()).add("AttributeFilter", (Object)this.attributeFilter()).add("RequestedDocumentAttributes", this.hasRequestedDocumentAttributes() ? this.requestedDocumentAttributes() : null).add("DocumentRelevanceOverrideConfigurations", this.hasDocumentRelevanceOverrideConfigurations() ? this.documentRelevanceOverrideConfigurations() : null).add("PageNumber", (Object)this.pageNumber()).add("PageSize", (Object)this.pageSize()).add("UserContext", (Object)this.userContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "QueryText": {
                return Optional.ofNullable(clazz.cast(this.queryText()));
            }
            case "AttributeFilter": {
                return Optional.ofNullable(clazz.cast(this.attributeFilter()));
            }
            case "RequestedDocumentAttributes": {
                return Optional.ofNullable(clazz.cast(this.requestedDocumentAttributes()));
            }
            case "DocumentRelevanceOverrideConfigurations": {
                return Optional.ofNullable(clazz.cast(this.documentRelevanceOverrideConfigurations()));
            }
            case "PageNumber": {
                return Optional.ofNullable(clazz.cast(this.pageNumber()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "UserContext": {
                return Optional.ofNullable(clazz.cast(this.userContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("QueryText", QUERY_TEXT_FIELD);
        map.put("AttributeFilter", ATTRIBUTE_FILTER_FIELD);
        map.put("RequestedDocumentAttributes", REQUESTED_DOCUMENT_ATTRIBUTES_FIELD);
        map.put("DocumentRelevanceOverrideConfigurations", DOCUMENT_RELEVANCE_OVERRIDE_CONFIGURATIONS_FIELD);
        map.put("PageNumber", PAGE_NUMBER_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        map.put("UserContext", USER_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrieveRequest, T> g) {
        return obj -> g.apply((RetrieveRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String indexId;
        private String queryText;
        private AttributeFilter attributeFilter;
        private List<String> requestedDocumentAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Integer pageNumber;
        private Integer pageSize;
        private UserContext userContext;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveRequest model) {
            super(model);
            this.indexId(model.indexId);
            this.queryText(model.queryText);
            this.attributeFilter(model.attributeFilter);
            this.requestedDocumentAttributes(model.requestedDocumentAttributes);
            this.documentRelevanceOverrideConfigurations(model.documentRelevanceOverrideConfigurations);
            this.pageNumber(model.pageNumber);
            this.pageSize(model.pageSize);
            this.userContext(model.userContext);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getQueryText() {
            return this.queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final AttributeFilter.Builder getAttributeFilter() {
            return this.attributeFilter != null ? this.attributeFilter.toBuilder() : null;
        }

        public final void setAttributeFilter(AttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        @Override
        public final Builder attributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        public final Collection<String> getRequestedDocumentAttributes() {
            if (this.requestedDocumentAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requestedDocumentAttributes;
        }

        public final void setRequestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
            this.requestedDocumentAttributes = DocumentAttributeKeyListCopier.copy(requestedDocumentAttributes);
        }

        @Override
        public final Builder requestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
            this.requestedDocumentAttributes = DocumentAttributeKeyListCopier.copy(requestedDocumentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedDocumentAttributes(String ... requestedDocumentAttributes) {
            this.requestedDocumentAttributes(Arrays.asList(requestedDocumentAttributes));
            return this;
        }

        public final List<DocumentRelevanceConfiguration.Builder> getDocumentRelevanceOverrideConfigurations() {
            List<DocumentRelevanceConfiguration.Builder> result = DocumentRelevanceOverrideConfigurationListCopier.copyToBuilder(this.documentRelevanceOverrideConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentRelevanceOverrideConfigurations(Collection<DocumentRelevanceConfiguration.BuilderImpl> documentRelevanceOverrideConfigurations) {
            this.documentRelevanceOverrideConfigurations = DocumentRelevanceOverrideConfigurationListCopier.copyFromBuilder(documentRelevanceOverrideConfigurations);
        }

        @Override
        public final Builder documentRelevanceOverrideConfigurations(Collection<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations) {
            this.documentRelevanceOverrideConfigurations = DocumentRelevanceOverrideConfigurationListCopier.copy(documentRelevanceOverrideConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentRelevanceOverrideConfigurations(DocumentRelevanceConfiguration ... documentRelevanceOverrideConfigurations) {
            this.documentRelevanceOverrideConfigurations(Arrays.asList(documentRelevanceOverrideConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentRelevanceOverrideConfigurations(Consumer<DocumentRelevanceConfiguration.Builder> ... documentRelevanceOverrideConfigurations) {
            this.documentRelevanceOverrideConfigurations(Stream.of(documentRelevanceOverrideConfigurations).map(c -> (DocumentRelevanceConfiguration)((DocumentRelevanceConfiguration.Builder)DocumentRelevanceConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getPageNumber() {
            return this.pageNumber;
        }

        public final void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        @Override
        public final Builder pageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final UserContext.Builder getUserContext() {
            return this.userContext != null ? this.userContext.toBuilder() : null;
        }

        public final void setUserContext(UserContext.BuilderImpl userContext) {
            this.userContext = userContext != null ? userContext.build() : null;
        }

        @Override
        public final Builder userContext(UserContext userContext) {
            this.userContext = userContext;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetrieveRequest build() {
            return new RetrieveRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RetrieveRequest> {
        public Builder indexId(String var1);

        public Builder queryText(String var1);

        public Builder attributeFilter(AttributeFilter var1);

        default public Builder attributeFilter(Consumer<AttributeFilter.Builder> attributeFilter) {
            return this.attributeFilter((AttributeFilter)((AttributeFilter.Builder)AttributeFilter.builder().applyMutation(attributeFilter)).build());
        }

        public Builder requestedDocumentAttributes(Collection<String> var1);

        public Builder requestedDocumentAttributes(String ... var1);

        public Builder documentRelevanceOverrideConfigurations(Collection<DocumentRelevanceConfiguration> var1);

        public Builder documentRelevanceOverrideConfigurations(DocumentRelevanceConfiguration ... var1);

        public Builder documentRelevanceOverrideConfigurations(Consumer<DocumentRelevanceConfiguration.Builder> ... var1);

        public Builder pageNumber(Integer var1);

        public Builder pageSize(Integer var1);

        public Builder userContext(UserContext var1);

        default public Builder userContext(Consumer<UserContext.Builder> userContext) {
            return this.userContext((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(userContext)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

