/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.PrincipalType;
import software.amazon.awssdk.services.kendra.model.ReadAccessType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Principal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Principal> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Principal.getter(Principal::name)).setter(Principal.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Principal.getter(Principal::typeAsString)).setter(Principal.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Access").getter(Principal.getter(Principal::accessAsString)).setter(Principal.setter(Builder::access)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Access").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceId").getter(Principal.getter(Principal::dataSourceId)).setter(Principal.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, ACCESS_FIELD, DATA_SOURCE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Principal.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final String access;
    private final String dataSourceId;

    private Principal(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.access = builder.access;
        this.dataSourceId = builder.dataSourceId;
    }

    public final String name() {
        return this.name;
    }

    public final PrincipalType type() {
        return PrincipalType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ReadAccessType access() {
        return ReadAccessType.fromValue(this.access);
    }

    public final String accessAsString() {
        return this.access;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Principal)) {
            return false;
        }
        Principal other = (Principal)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.accessAsString(), other.accessAsString()) && Objects.equals(this.dataSourceId(), other.dataSourceId());
    }

    public final String toString() {
        return ToString.builder((String)"Principal").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Access", (Object)this.accessAsString()).add("DataSourceId", (Object)this.dataSourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Access": {
                return Optional.ofNullable(clazz.cast(this.accessAsString()));
            }
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Access", ACCESS_FIELD);
        map.put("DataSourceId", DATA_SOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Principal, T> g) {
        return obj -> g.apply((Principal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String access;
        private String dataSourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(Principal model) {
            this.name(model.name);
            this.type(model.type);
            this.access(model.access);
            this.dataSourceId(model.dataSourceId);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PrincipalType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAccess() {
            return this.access;
        }

        public final void setAccess(String access) {
            this.access = access;
        }

        @Override
        public final Builder access(String access) {
            this.access = access;
            return this;
        }

        @Override
        public final Builder access(ReadAccessType access) {
            this.access(access == null ? null : access.toString());
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public Principal build() {
            return new Principal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Principal> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(PrincipalType var1);

        public Builder access(String var1);

        public Builder access(ReadAccessType var1);

        public Builder dataSourceId(String var1);
    }
}

