/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal;
import software.amazon.awssdk.services.kendra.model.HierarchicalPrincipalListCopier;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.Principal;
import software.amazon.awssdk.services.kendra.model.PrincipalListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccessControlConfigurationResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, DescribeAccessControlConfigurationResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeAccessControlConfigurationResponse.getter(DescribeAccessControlConfigurationResponse::name)).setter(DescribeAccessControlConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeAccessControlConfigurationResponse.getter(DescribeAccessControlConfigurationResponse::description)).setter(DescribeAccessControlConfigurationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(DescribeAccessControlConfigurationResponse.getter(DescribeAccessControlConfigurationResponse::errorMessage)).setter(DescribeAccessControlConfigurationResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<List<Principal>> ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessControlList").getter(DescribeAccessControlConfigurationResponse.getter(DescribeAccessControlConfigurationResponse::accessControlList)).setter(DescribeAccessControlConfigurationResponse.setter(Builder::accessControlList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Principal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HierarchicalPrincipal>> HIERARCHICAL_ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HierarchicalAccessControlList").getter(DescribeAccessControlConfigurationResponse.getter(DescribeAccessControlConfigurationResponse::hierarchicalAccessControlList)).setter(DescribeAccessControlConfigurationResponse.setter(Builder::hierarchicalAccessControlList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchicalAccessControlList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HierarchicalPrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ERROR_MESSAGE_FIELD, ACCESS_CONTROL_LIST_FIELD, HIERARCHICAL_ACCESS_CONTROL_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAccessControlConfigurationResponse.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String errorMessage;
    private final List<Principal> accessControlList;
    private final List<HierarchicalPrincipal> hierarchicalAccessControlList;

    private DescribeAccessControlConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.errorMessage = builder.errorMessage;
        this.accessControlList = builder.accessControlList;
        this.hierarchicalAccessControlList = builder.hierarchicalAccessControlList;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final boolean hasAccessControlList() {
        return this.accessControlList != null && !(this.accessControlList instanceof SdkAutoConstructList);
    }

    public final List<Principal> accessControlList() {
        return this.accessControlList;
    }

    public final boolean hasHierarchicalAccessControlList() {
        return this.hierarchicalAccessControlList != null && !(this.hierarchicalAccessControlList instanceof SdkAutoConstructList);
    }

    public final List<HierarchicalPrincipal> hierarchicalAccessControlList() {
        return this.hierarchicalAccessControlList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessControlList() ? this.accessControlList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHierarchicalAccessControlList() ? this.hierarchicalAccessControlList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccessControlConfigurationResponse)) {
            return false;
        }
        DescribeAccessControlConfigurationResponse other = (DescribeAccessControlConfigurationResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.errorMessage(), other.errorMessage()) && this.hasAccessControlList() == other.hasAccessControlList() && Objects.equals(this.accessControlList(), other.accessControlList()) && this.hasHierarchicalAccessControlList() == other.hasHierarchicalAccessControlList() && Objects.equals(this.hierarchicalAccessControlList(), other.hierarchicalAccessControlList());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccessControlConfigurationResponse").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ErrorMessage", (Object)this.errorMessage()).add("AccessControlList", this.hasAccessControlList() ? this.accessControlList() : null).add("HierarchicalAccessControlList", this.hasHierarchicalAccessControlList() ? this.hierarchicalAccessControlList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "AccessControlList": {
                return Optional.ofNullable(clazz.cast(this.accessControlList()));
            }
            case "HierarchicalAccessControlList": {
                return Optional.ofNullable(clazz.cast(this.hierarchicalAccessControlList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("AccessControlList", ACCESS_CONTROL_LIST_FIELD);
        map.put("HierarchicalAccessControlList", HIERARCHICAL_ACCESS_CONTROL_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccessControlConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeAccessControlConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String errorMessage;
        private List<Principal> accessControlList = DefaultSdkAutoConstructList.getInstance();
        private List<HierarchicalPrincipal> hierarchicalAccessControlList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccessControlConfigurationResponse model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.errorMessage(model.errorMessage);
            this.accessControlList(model.accessControlList);
            this.hierarchicalAccessControlList(model.hierarchicalAccessControlList);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final List<Principal.Builder> getAccessControlList() {
            List<Principal.Builder> result = PrincipalListCopier.copyToBuilder(this.accessControlList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessControlList(Collection<Principal.BuilderImpl> accessControlList) {
            this.accessControlList = PrincipalListCopier.copyFromBuilder(accessControlList);
        }

        @Override
        public final Builder accessControlList(Collection<Principal> accessControlList) {
            this.accessControlList = PrincipalListCopier.copy(accessControlList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlList(Principal ... accessControlList) {
            this.accessControlList(Arrays.asList(accessControlList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlList(Consumer<Principal.Builder> ... accessControlList) {
            this.accessControlList(Stream.of(accessControlList).map(c -> (Principal)((Principal.Builder)Principal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<HierarchicalPrincipal.Builder> getHierarchicalAccessControlList() {
            List<HierarchicalPrincipal.Builder> result = HierarchicalPrincipalListCopier.copyToBuilder(this.hierarchicalAccessControlList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHierarchicalAccessControlList(Collection<HierarchicalPrincipal.BuilderImpl> hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList = HierarchicalPrincipalListCopier.copyFromBuilder(hierarchicalAccessControlList);
        }

        @Override
        public final Builder hierarchicalAccessControlList(Collection<HierarchicalPrincipal> hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList = HierarchicalPrincipalListCopier.copy(hierarchicalAccessControlList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchicalAccessControlList(HierarchicalPrincipal ... hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList(Arrays.asList(hierarchicalAccessControlList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchicalAccessControlList(Consumer<HierarchicalPrincipal.Builder> ... hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList(Stream.of(hierarchicalAccessControlList).map(c -> (HierarchicalPrincipal)((HierarchicalPrincipal.Builder)HierarchicalPrincipal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAccessControlConfigurationResponse build() {
            return new DescribeAccessControlConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccessControlConfigurationResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder errorMessage(String var1);

        public Builder accessControlList(Collection<Principal> var1);

        public Builder accessControlList(Principal ... var1);

        public Builder accessControlList(Consumer<Principal.Builder> ... var1);

        public Builder hierarchicalAccessControlList(Collection<HierarchicalPrincipal> var1);

        public Builder hierarchicalAccessControlList(HierarchicalPrincipal ... var1);

        public Builder hierarchicalAccessControlList(Consumer<HierarchicalPrincipal.Builder> ... var1);
    }
}

