/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType;
import software.amazon.awssdk.services.kendra.model.Relevance;
import software.amazon.awssdk.services.kendra.model.Search;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentMetadataConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentMetadataConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DocumentMetadataConfiguration.getter(DocumentMetadataConfiguration::name)).setter(DocumentMetadataConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DocumentMetadataConfiguration.getter(DocumentMetadataConfiguration::typeAsString)).setter(DocumentMetadataConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Relevance> RELEVANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Relevance").getter(DocumentMetadataConfiguration.getter(DocumentMetadataConfiguration::relevance)).setter(DocumentMetadataConfiguration.setter(Builder::relevance)).constructor(Relevance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relevance").build()}).build();
    private static final SdkField<Search> SEARCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Search").getter(DocumentMetadataConfiguration.getter(DocumentMetadataConfiguration::search)).setter(DocumentMetadataConfiguration.setter(Builder::search)).constructor(Search::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Search").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, RELEVANCE_FIELD, SEARCH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentMetadataConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final Relevance relevance;
    private final Search search;

    private DocumentMetadataConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.relevance = builder.relevance;
        this.search = builder.search;
    }

    public final String name() {
        return this.name;
    }

    public final DocumentAttributeValueType type() {
        return DocumentAttributeValueType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Relevance relevance() {
        return this.relevance;
    }

    public final Search search() {
        return this.search;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.relevance());
        hashCode = 31 * hashCode + Objects.hashCode(this.search());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadataConfiguration)) {
            return false;
        }
        DocumentMetadataConfiguration other = (DocumentMetadataConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.relevance(), other.relevance()) && Objects.equals(this.search(), other.search());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentMetadataConfiguration").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Relevance", (Object)this.relevance()).add("Search", (Object)this.search()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Relevance": {
                return Optional.ofNullable(clazz.cast(this.relevance()));
            }
            case "Search": {
                return Optional.ofNullable(clazz.cast(this.search()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Relevance", RELEVANCE_FIELD);
        map.put("Search", SEARCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentMetadataConfiguration, T> g) {
        return obj -> g.apply((DocumentMetadataConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private Relevance relevance;
        private Search search;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentMetadataConfiguration model) {
            this.name(model.name);
            this.type(model.type);
            this.relevance(model.relevance);
            this.search(model.search);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DocumentAttributeValueType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Relevance.Builder getRelevance() {
            return this.relevance != null ? this.relevance.toBuilder() : null;
        }

        public final void setRelevance(Relevance.BuilderImpl relevance) {
            this.relevance = relevance != null ? relevance.build() : null;
        }

        @Override
        public final Builder relevance(Relevance relevance) {
            this.relevance = relevance;
            return this;
        }

        public final Search.Builder getSearch() {
            return this.search != null ? this.search.toBuilder() : null;
        }

        public final void setSearch(Search.BuilderImpl search) {
            this.search = search != null ? search.build() : null;
        }

        @Override
        public final Builder search(Search search) {
            this.search = search;
            return this;
        }

        public DocumentMetadataConfiguration build() {
            return new DocumentMetadataConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentMetadataConfiguration> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(DocumentAttributeValueType var1);

        public Builder relevance(Relevance var1);

        default public Builder relevance(Consumer<Relevance.Builder> relevance) {
            return this.relevance((Relevance)((Relevance.Builder)Relevance.builder().applyMutation(relevance)).build());
        }

        public Builder search(Search var1);

        default public Builder search(Consumer<Search.Builder> search) {
            return this.search((Search)((Search.Builder)Search.builder().applyMutation(search)).build());
        }
    }
}

