/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.ContentType;
import software.amazon.awssdk.services.kendra.model.DocumentAttribute;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeListCopier;
import software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal;
import software.amazon.awssdk.services.kendra.model.HierarchicalPrincipalListCopier;
import software.amazon.awssdk.services.kendra.model.Principal;
import software.amazon.awssdk.services.kendra.model.PrincipalListCopier;
import software.amazon.awssdk.services.kendra.model.S3Path;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Document
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Document> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Document.getter(Document::id)).setter(Document.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(Document.getter(Document::title)).setter(Document.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<SdkBytes> BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Blob").getter(Document.getter(Document::blob)).setter(Document.setter(Builder::blob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blob").build()}).build();
    private static final SdkField<S3Path> S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Path").getter(Document.getter(Document::s3Path)).setter(Document.setter(Builder::s3Path)).constructor(S3Path::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Path").build()}).build();
    private static final SdkField<List<DocumentAttribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(Document.getter(Document::attributes)).setter(Document.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Principal>> ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessControlList").getter(Document.getter(Document::accessControlList)).setter(Document.setter(Builder::accessControlList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Principal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HierarchicalPrincipal>> HIERARCHICAL_ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HierarchicalAccessControlList").getter(Document.getter(Document::hierarchicalAccessControlList)).setter(Document.setter(Builder::hierarchicalAccessControlList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchicalAccessControlList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HierarchicalPrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(Document.getter(Document::contentTypeAsString)).setter(Document.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<String> ACCESS_CONTROL_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessControlConfigurationId").getter(Document.getter(Document::accessControlConfigurationId)).setter(Document.setter(Builder::accessControlConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlConfigurationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TITLE_FIELD, BLOB_FIELD, S3_PATH_FIELD, ATTRIBUTES_FIELD, ACCESS_CONTROL_LIST_FIELD, HIERARCHICAL_ACCESS_CONTROL_LIST_FIELD, CONTENT_TYPE_FIELD, ACCESS_CONTROL_CONFIGURATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Document.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String title;
    private final SdkBytes blob;
    private final S3Path s3Path;
    private final List<DocumentAttribute> attributes;
    private final List<Principal> accessControlList;
    private final List<HierarchicalPrincipal> hierarchicalAccessControlList;
    private final String contentType;
    private final String accessControlConfigurationId;

    private Document(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.blob = builder.blob;
        this.s3Path = builder.s3Path;
        this.attributes = builder.attributes;
        this.accessControlList = builder.accessControlList;
        this.hierarchicalAccessControlList = builder.hierarchicalAccessControlList;
        this.contentType = builder.contentType;
        this.accessControlConfigurationId = builder.accessControlConfigurationId;
    }

    public final String id() {
        return this.id;
    }

    public final String title() {
        return this.title;
    }

    public final SdkBytes blob() {
        return this.blob;
    }

    public final S3Path s3Path() {
        return this.s3Path;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<DocumentAttribute> attributes() {
        return this.attributes;
    }

    public final boolean hasAccessControlList() {
        return this.accessControlList != null && !(this.accessControlList instanceof SdkAutoConstructList);
    }

    public final List<Principal> accessControlList() {
        return this.accessControlList;
    }

    public final boolean hasHierarchicalAccessControlList() {
        return this.hierarchicalAccessControlList != null && !(this.hierarchicalAccessControlList instanceof SdkAutoConstructList);
    }

    public final List<HierarchicalPrincipal> hierarchicalAccessControlList() {
        return this.hierarchicalAccessControlList;
    }

    public final ContentType contentType() {
        return ContentType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public final String accessControlConfigurationId() {
        return this.accessControlConfigurationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.blob());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessControlList() ? this.accessControlList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHierarchicalAccessControlList() ? this.hierarchicalAccessControlList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessControlConfigurationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Document)) {
            return false;
        }
        Document other = (Document)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.blob(), other.blob()) && Objects.equals(this.s3Path(), other.s3Path()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasAccessControlList() == other.hasAccessControlList() && Objects.equals(this.accessControlList(), other.accessControlList()) && this.hasHierarchicalAccessControlList() == other.hasHierarchicalAccessControlList() && Objects.equals(this.hierarchicalAccessControlList(), other.hierarchicalAccessControlList()) && Objects.equals(this.contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(this.accessControlConfigurationId(), other.accessControlConfigurationId());
    }

    public final String toString() {
        return ToString.builder((String)"Document").add("Id", (Object)this.id()).add("Title", (Object)this.title()).add("Blob", (Object)this.blob()).add("S3Path", (Object)this.s3Path()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("AccessControlList", this.hasAccessControlList() ? this.accessControlList() : null).add("HierarchicalAccessControlList", this.hasHierarchicalAccessControlList() ? this.hierarchicalAccessControlList() : null).add("ContentType", (Object)this.contentTypeAsString()).add("AccessControlConfigurationId", (Object)this.accessControlConfigurationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Blob": {
                return Optional.ofNullable(clazz.cast(this.blob()));
            }
            case "S3Path": {
                return Optional.ofNullable(clazz.cast(this.s3Path()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "AccessControlList": {
                return Optional.ofNullable(clazz.cast(this.accessControlList()));
            }
            case "HierarchicalAccessControlList": {
                return Optional.ofNullable(clazz.cast(this.hierarchicalAccessControlList()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
            case "AccessControlConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.accessControlConfigurationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Blob", BLOB_FIELD);
        map.put("S3Path", S3_PATH_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("AccessControlList", ACCESS_CONTROL_LIST_FIELD);
        map.put("HierarchicalAccessControlList", HIERARCHICAL_ACCESS_CONTROL_LIST_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        map.put("AccessControlConfigurationId", ACCESS_CONTROL_CONFIGURATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Document, T> g) {
        return obj -> g.apply((Document)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String title;
        private SdkBytes blob;
        private S3Path s3Path;
        private List<DocumentAttribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private List<Principal> accessControlList = DefaultSdkAutoConstructList.getInstance();
        private List<HierarchicalPrincipal> hierarchicalAccessControlList = DefaultSdkAutoConstructList.getInstance();
        private String contentType;
        private String accessControlConfigurationId;

        private BuilderImpl() {
        }

        private BuilderImpl(Document model) {
            this.id(model.id);
            this.title(model.title);
            this.blob(model.blob);
            this.s3Path(model.s3Path);
            this.attributes(model.attributes);
            this.accessControlList(model.accessControlList);
            this.hierarchicalAccessControlList(model.hierarchicalAccessControlList);
            this.contentType(model.contentType);
            this.accessControlConfigurationId(model.accessControlConfigurationId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final ByteBuffer getBlob() {
            return this.blob == null ? null : this.blob.asByteBuffer();
        }

        public final void setBlob(ByteBuffer blob) {
            this.blob(blob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)blob));
        }

        @Override
        public final Builder blob(SdkBytes blob) {
            this.blob = blob;
            return this;
        }

        public final S3Path.Builder getS3Path() {
            return this.s3Path != null ? this.s3Path.toBuilder() : null;
        }

        public final void setS3Path(S3Path.BuilderImpl s3Path) {
            this.s3Path = s3Path != null ? s3Path.build() : null;
        }

        @Override
        public final Builder s3Path(S3Path s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final List<DocumentAttribute.Builder> getAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<DocumentAttribute.BuilderImpl> attributes) {
            this.attributes = DocumentAttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<DocumentAttribute> attributes) {
            this.attributes = DocumentAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(DocumentAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<DocumentAttribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (DocumentAttribute)((DocumentAttribute.Builder)DocumentAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Principal.Builder> getAccessControlList() {
            List<Principal.Builder> result = PrincipalListCopier.copyToBuilder(this.accessControlList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessControlList(Collection<Principal.BuilderImpl> accessControlList) {
            this.accessControlList = PrincipalListCopier.copyFromBuilder(accessControlList);
        }

        @Override
        public final Builder accessControlList(Collection<Principal> accessControlList) {
            this.accessControlList = PrincipalListCopier.copy(accessControlList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlList(Principal ... accessControlList) {
            this.accessControlList(Arrays.asList(accessControlList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlList(Consumer<Principal.Builder> ... accessControlList) {
            this.accessControlList(Stream.of(accessControlList).map(c -> (Principal)((Principal.Builder)Principal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<HierarchicalPrincipal.Builder> getHierarchicalAccessControlList() {
            List<HierarchicalPrincipal.Builder> result = HierarchicalPrincipalListCopier.copyToBuilder(this.hierarchicalAccessControlList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHierarchicalAccessControlList(Collection<HierarchicalPrincipal.BuilderImpl> hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList = HierarchicalPrincipalListCopier.copyFromBuilder(hierarchicalAccessControlList);
        }

        @Override
        public final Builder hierarchicalAccessControlList(Collection<HierarchicalPrincipal> hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList = HierarchicalPrincipalListCopier.copy(hierarchicalAccessControlList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchicalAccessControlList(HierarchicalPrincipal ... hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList(Arrays.asList(hierarchicalAccessControlList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchicalAccessControlList(Consumer<HierarchicalPrincipal.Builder> ... hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList(Stream.of(hierarchicalAccessControlList).map(c -> (HierarchicalPrincipal)((HierarchicalPrincipal.Builder)HierarchicalPrincipal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(ContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final String getAccessControlConfigurationId() {
            return this.accessControlConfigurationId;
        }

        public final void setAccessControlConfigurationId(String accessControlConfigurationId) {
            this.accessControlConfigurationId = accessControlConfigurationId;
        }

        @Override
        public final Builder accessControlConfigurationId(String accessControlConfigurationId) {
            this.accessControlConfigurationId = accessControlConfigurationId;
            return this;
        }

        public Document build() {
            return new Document(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Document> {
        public Builder id(String var1);

        public Builder title(String var1);

        public Builder blob(SdkBytes var1);

        public Builder s3Path(S3Path var1);

        default public Builder s3Path(Consumer<S3Path.Builder> s3Path) {
            return this.s3Path((S3Path)((S3Path.Builder)S3Path.builder().applyMutation(s3Path)).build());
        }

        public Builder attributes(Collection<DocumentAttribute> var1);

        public Builder attributes(DocumentAttribute ... var1);

        public Builder attributes(Consumer<DocumentAttribute.Builder> ... var1);

        public Builder accessControlList(Collection<Principal> var1);

        public Builder accessControlList(Principal ... var1);

        public Builder accessControlList(Consumer<Principal.Builder> ... var1);

        public Builder hierarchicalAccessControlList(Collection<HierarchicalPrincipal> var1);

        public Builder hierarchicalAccessControlList(HierarchicalPrincipal ... var1);

        public Builder hierarchicalAccessControlList(Consumer<HierarchicalPrincipal.Builder> ... var1);

        public Builder contentType(String var1);

        public Builder contentType(ContentType var1);

        public Builder accessControlConfigurationId(String var1);
    }
}

