/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.S3Path;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OnPremiseConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OnPremiseConfiguration> {
    private static final SdkField<String> HOST_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostUrl").getter(OnPremiseConfiguration.getter(OnPremiseConfiguration::hostUrl)).setter(OnPremiseConfiguration.setter(Builder::hostUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostUrl").build()}).build();
    private static final SdkField<String> ORGANIZATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationName").getter(OnPremiseConfiguration.getter(OnPremiseConfiguration::organizationName)).setter(OnPremiseConfiguration.setter(Builder::organizationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationName").build()}).build();
    private static final SdkField<S3Path> SSL_CERTIFICATE_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SslCertificateS3Path").getter(OnPremiseConfiguration.getter(OnPremiseConfiguration::sslCertificateS3Path)).setter(OnPremiseConfiguration.setter(Builder::sslCertificateS3Path)).constructor(S3Path::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslCertificateS3Path").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_URL_FIELD, ORGANIZATION_NAME_FIELD, SSL_CERTIFICATE_S3_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OnPremiseConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hostUrl;
    private final String organizationName;
    private final S3Path sslCertificateS3Path;

    private OnPremiseConfiguration(BuilderImpl builder) {
        this.hostUrl = builder.hostUrl;
        this.organizationName = builder.organizationName;
        this.sslCertificateS3Path = builder.sslCertificateS3Path;
    }

    public final String hostUrl() {
        return this.hostUrl;
    }

    public final String organizationName() {
        return this.organizationName;
    }

    public final S3Path sslCertificateS3Path() {
        return this.sslCertificateS3Path;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslCertificateS3Path());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnPremiseConfiguration)) {
            return false;
        }
        OnPremiseConfiguration other = (OnPremiseConfiguration)obj;
        return Objects.equals(this.hostUrl(), other.hostUrl()) && Objects.equals(this.organizationName(), other.organizationName()) && Objects.equals(this.sslCertificateS3Path(), other.sslCertificateS3Path());
    }

    public final String toString() {
        return ToString.builder((String)"OnPremiseConfiguration").add("HostUrl", (Object)this.hostUrl()).add("OrganizationName", (Object)this.organizationName()).add("SslCertificateS3Path", (Object)this.sslCertificateS3Path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostUrl": {
                return Optional.ofNullable(clazz.cast(this.hostUrl()));
            }
            case "OrganizationName": {
                return Optional.ofNullable(clazz.cast(this.organizationName()));
            }
            case "SslCertificateS3Path": {
                return Optional.ofNullable(clazz.cast(this.sslCertificateS3Path()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HostUrl", HOST_URL_FIELD);
        map.put("OrganizationName", ORGANIZATION_NAME_FIELD);
        map.put("SslCertificateS3Path", SSL_CERTIFICATE_S3_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OnPremiseConfiguration, T> g) {
        return obj -> g.apply((OnPremiseConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostUrl;
        private String organizationName;
        private S3Path sslCertificateS3Path;

        private BuilderImpl() {
        }

        private BuilderImpl(OnPremiseConfiguration model) {
            this.hostUrl(model.hostUrl);
            this.organizationName(model.organizationName);
            this.sslCertificateS3Path(model.sslCertificateS3Path);
        }

        public final String getHostUrl() {
            return this.hostUrl;
        }

        public final void setHostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
        }

        @Override
        public final Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public final String getOrganizationName() {
            return this.organizationName;
        }

        public final void setOrganizationName(String organizationName) {
            this.organizationName = organizationName;
        }

        @Override
        public final Builder organizationName(String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        public final S3Path.Builder getSslCertificateS3Path() {
            return this.sslCertificateS3Path != null ? this.sslCertificateS3Path.toBuilder() : null;
        }

        public final void setSslCertificateS3Path(S3Path.BuilderImpl sslCertificateS3Path) {
            this.sslCertificateS3Path = sslCertificateS3Path != null ? sslCertificateS3Path.build() : null;
        }

        @Override
        public final Builder sslCertificateS3Path(S3Path sslCertificateS3Path) {
            this.sslCertificateS3Path = sslCertificateS3Path;
            return this;
        }

        public OnPremiseConfiguration build() {
            return new OnPremiseConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OnPremiseConfiguration> {
        public Builder hostUrl(String var1);

        public Builder organizationName(String var1);

        public Builder sslCertificateS3Path(S3Path var1);

        default public Builder sslCertificateS3Path(Consumer<S3Path.Builder> sslCertificateS3Path) {
            return this.sslCertificateS3Path((S3Path)((S3Path.Builder)S3Path.builder().applyMutation(sslCertificateS3Path)).build());
        }
    }
}

