/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.PersonasSummary;
import software.amazon.awssdk.services.kendra.model.PersonasSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntityPersonasResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, ListEntityPersonasResponse> {
    private static final SdkField<List<PersonasSummary>> SUMMARY_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SummaryItems").getter(ListEntityPersonasResponse.getter(ListEntityPersonasResponse::summaryItems)).setter(ListEntityPersonasResponse.setter(Builder::summaryItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PersonasSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEntityPersonasResponse.getter(ListEntityPersonasResponse::nextToken)).setter(ListEntityPersonasResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEntityPersonasResponse.memberNameToFieldInitializer();
    private final List<PersonasSummary> summaryItems;
    private final String nextToken;

    private ListEntityPersonasResponse(BuilderImpl builder) {
        super(builder);
        this.summaryItems = builder.summaryItems;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSummaryItems() {
        return this.summaryItems != null && !(this.summaryItems instanceof SdkAutoConstructList);
    }

    public final List<PersonasSummary> summaryItems() {
        return this.summaryItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaryItems() ? this.summaryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntityPersonasResponse)) {
            return false;
        }
        ListEntityPersonasResponse other = (ListEntityPersonasResponse)((Object)obj);
        return this.hasSummaryItems() == other.hasSummaryItems() && Objects.equals(this.summaryItems(), other.summaryItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEntityPersonasResponse").add("SummaryItems", this.hasSummaryItems() ? this.summaryItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SummaryItems": {
                return Optional.ofNullable(clazz.cast(this.summaryItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SummaryItems", SUMMARY_ITEMS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEntityPersonasResponse, T> g) {
        return obj -> g.apply((ListEntityPersonasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private List<PersonasSummary> summaryItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntityPersonasResponse model) {
            super(model);
            this.summaryItems(model.summaryItems);
            this.nextToken(model.nextToken);
        }

        public final List<PersonasSummary.Builder> getSummaryItems() {
            List<PersonasSummary.Builder> result = PersonasSummaryListCopier.copyToBuilder(this.summaryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaryItems(Collection<PersonasSummary.BuilderImpl> summaryItems) {
            this.summaryItems = PersonasSummaryListCopier.copyFromBuilder(summaryItems);
        }

        @Override
        public final Builder summaryItems(Collection<PersonasSummary> summaryItems) {
            this.summaryItems = PersonasSummaryListCopier.copy(summaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryItems(PersonasSummary ... summaryItems) {
            this.summaryItems(Arrays.asList(summaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryItems(Consumer<PersonasSummary.Builder> ... summaryItems) {
            this.summaryItems(Stream.of(summaryItems).map(c -> (PersonasSummary)((PersonasSummary.Builder)PersonasSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEntityPersonasResponse build() {
            return new ListEntityPersonasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEntityPersonasResponse> {
        public Builder summaryItems(Collection<PersonasSummary> var1);

        public Builder summaryItems(PersonasSummary ... var1);

        public Builder summaryItems(Consumer<PersonasSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

