/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SharePointVersion {
    SHAREPOINT_2013("SHAREPOINT_2013"),
    SHAREPOINT_2016("SHAREPOINT_2016"),
    SHAREPOINT_ONLINE("SHAREPOINT_ONLINE"),
    SHAREPOINT_2019("SHAREPOINT_2019"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SharePointVersion> VALUE_MAP;
    private final String value;

    private SharePointVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SharePointVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SharePointVersion> knownValues() {
        EnumSet<SharePointVersion> knownValues = EnumSet.allOf(SharePointVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SharePointVersion.class, SharePointVersion::toString);
    }
}

