/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponseFailedDocument;
import software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponseFailedDocumentsCopier;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteDocumentResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, BatchDeleteDocumentResponse> {
    private static final SdkField<List<BatchDeleteDocumentResponseFailedDocument>> FAILED_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedDocuments").getter(BatchDeleteDocumentResponse.getter(BatchDeleteDocumentResponse::failedDocuments)).setter(BatchDeleteDocumentResponse.setter(Builder::failedDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDeleteDocumentResponseFailedDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_DOCUMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteDocumentResponse.memberNameToFieldInitializer();
    private final List<BatchDeleteDocumentResponseFailedDocument> failedDocuments;

    private BatchDeleteDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.failedDocuments = builder.failedDocuments;
    }

    public final boolean hasFailedDocuments() {
        return this.failedDocuments != null && !(this.failedDocuments instanceof SdkAutoConstructList);
    }

    public final List<BatchDeleteDocumentResponseFailedDocument> failedDocuments() {
        return this.failedDocuments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedDocuments() ? this.failedDocuments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteDocumentResponse)) {
            return false;
        }
        BatchDeleteDocumentResponse other = (BatchDeleteDocumentResponse)((Object)obj);
        return this.hasFailedDocuments() == other.hasFailedDocuments() && Objects.equals(this.failedDocuments(), other.failedDocuments());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteDocumentResponse").add("FailedDocuments", this.hasFailedDocuments() ? this.failedDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedDocuments": {
                return Optional.ofNullable(clazz.cast(this.failedDocuments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<BatchDeleteDocumentResponseFailedDocument>>> map = new HashMap<String, SdkField<List<BatchDeleteDocumentResponseFailedDocument>>>();
        map.put("FailedDocuments", FAILED_DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteDocumentResponse, T> g) {
        return obj -> g.apply((BatchDeleteDocumentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private List<BatchDeleteDocumentResponseFailedDocument> failedDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteDocumentResponse model) {
            super(model);
            this.failedDocuments(model.failedDocuments);
        }

        public final List<BatchDeleteDocumentResponseFailedDocument.Builder> getFailedDocuments() {
            List<BatchDeleteDocumentResponseFailedDocument.Builder> result = BatchDeleteDocumentResponseFailedDocumentsCopier.copyToBuilder(this.failedDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedDocuments(Collection<BatchDeleteDocumentResponseFailedDocument.BuilderImpl> failedDocuments) {
            this.failedDocuments = BatchDeleteDocumentResponseFailedDocumentsCopier.copyFromBuilder(failedDocuments);
        }

        @Override
        public final Builder failedDocuments(Collection<BatchDeleteDocumentResponseFailedDocument> failedDocuments) {
            this.failedDocuments = BatchDeleteDocumentResponseFailedDocumentsCopier.copy(failedDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedDocuments(BatchDeleteDocumentResponseFailedDocument ... failedDocuments) {
            this.failedDocuments(Arrays.asList(failedDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedDocuments(Consumer<BatchDeleteDocumentResponseFailedDocument.Builder> ... failedDocuments) {
            this.failedDocuments(Stream.of(failedDocuments).map(c -> (BatchDeleteDocumentResponseFailedDocument)((BatchDeleteDocumentResponseFailedDocument.Builder)BatchDeleteDocumentResponseFailedDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDeleteDocumentResponse build() {
            return new BatchDeleteDocumentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteDocumentResponse> {
        public Builder failedDocuments(Collection<BatchDeleteDocumentResponseFailedDocument> var1);

        public Builder failedDocuments(BatchDeleteDocumentResponseFailedDocument ... var1);

        public Builder failedDocuments(Consumer<BatchDeleteDocumentResponseFailedDocument.Builder> ... var1);
    }
}

