/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.AlfrescoEntity;
import software.amazon.awssdk.services.kendra.model.DataSourceInclusionsExclusionsStringsCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration;
import software.amazon.awssdk.services.kendra.model.EntityFilterCopier;
import software.amazon.awssdk.services.kendra.model.S3Path;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlfrescoConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlfrescoConfiguration> {
    private static final SdkField<String> SITE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SiteUrl").getter(AlfrescoConfiguration.getter(AlfrescoConfiguration::siteUrl)).setter(AlfrescoConfiguration.setter(Builder::siteUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteUrl").build()}).build();
    private static final SdkField<String> SITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SiteId").getter(AlfrescoConfiguration.getter(AlfrescoConfiguration::siteId)).setter(AlfrescoConfiguration.setter(Builder::siteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteId").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(AlfrescoConfiguration.getter(AlfrescoConfiguration::secretArn)).setter(AlfrescoConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<S3Path> SSL_CERTIFICATE_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SslCertificateS3Path").getter(AlfrescoConfiguration.getter(AlfrescoConfiguration::sslCertificateS3Path)).setter(AlfrescoConfiguration.setter(Builder::sslCertificateS3Path)).constructor(S3Path::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslCertificateS3Path").build()}).build();
    private static final SdkField<Boolean> CRAWL_SYSTEM_FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrawlSystemFolders").getter(AlfrescoConfiguration.getter(AlfrescoConfiguration::crawlSystemFolders)).setter(AlfrescoConfiguration.setter(Builder::crawlSystemFolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlSystemFolders").build()}).build();
    private static final SdkField<Boolean> CRAWL_COMMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrawlComments").getter(AlfrescoConfiguration.getter(AlfrescoConfiguration::crawlComments)).setter(AlfrescoConfiguration.setter(Builder::crawlComments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlComments").build()}).build();
    private static final SdkField<List<String>> ENTITY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityFilter").getter(AlfrescoConfiguration.getter(AlfrescoConfiguration::entityFilterAsStrings)).setter(AlfrescoConfiguration.setter(Builder::entityFilterWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> DOCUMENT_LIBRARY_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentLibraryFieldMappings").getter(AlfrescoConfiguration.getter(AlfrescoConfiguration::documentLibraryFieldMappings)).setter(AlfrescoConfiguration.setter(Builder::documentLibraryFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentLibraryFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> BLOG_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlogFieldMappings").getter(AlfrescoConfiguration.getter(AlfrescoConfiguration::blogFieldMappings)).setter(AlfrescoConfiguration.setter(Builder::blogFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlogFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> WIKI_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WikiFieldMappings").getter(AlfrescoConfiguration.getter(AlfrescoConfiguration::wikiFieldMappings)).setter(AlfrescoConfiguration.setter(Builder::wikiFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WikiFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionPatterns").getter(AlfrescoConfiguration.getter(AlfrescoConfiguration::inclusionPatterns)).setter(AlfrescoConfiguration.setter(Builder::inclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionPatterns").getter(AlfrescoConfiguration.getter(AlfrescoConfiguration::exclusionPatterns)).setter(AlfrescoConfiguration.setter(Builder::exclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(AlfrescoConfiguration.getter(AlfrescoConfiguration::vpcConfiguration)).setter(AlfrescoConfiguration.setter(Builder::vpcConfiguration)).constructor(DataSourceVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITE_URL_FIELD, SITE_ID_FIELD, SECRET_ARN_FIELD, SSL_CERTIFICATE_S3_PATH_FIELD, CRAWL_SYSTEM_FOLDERS_FIELD, CRAWL_COMMENTS_FIELD, ENTITY_FILTER_FIELD, DOCUMENT_LIBRARY_FIELD_MAPPINGS_FIELD, BLOG_FIELD_MAPPINGS_FIELD, WIKI_FIELD_MAPPINGS_FIELD, INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, VPC_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AlfrescoConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String siteUrl;
    private final String siteId;
    private final String secretArn;
    private final S3Path sslCertificateS3Path;
    private final Boolean crawlSystemFolders;
    private final Boolean crawlComments;
    private final List<String> entityFilter;
    private final List<DataSourceToIndexFieldMapping> documentLibraryFieldMappings;
    private final List<DataSourceToIndexFieldMapping> blogFieldMappings;
    private final List<DataSourceToIndexFieldMapping> wikiFieldMappings;
    private final List<String> inclusionPatterns;
    private final List<String> exclusionPatterns;
    private final DataSourceVpcConfiguration vpcConfiguration;

    private AlfrescoConfiguration(BuilderImpl builder) {
        this.siteUrl = builder.siteUrl;
        this.siteId = builder.siteId;
        this.secretArn = builder.secretArn;
        this.sslCertificateS3Path = builder.sslCertificateS3Path;
        this.crawlSystemFolders = builder.crawlSystemFolders;
        this.crawlComments = builder.crawlComments;
        this.entityFilter = builder.entityFilter;
        this.documentLibraryFieldMappings = builder.documentLibraryFieldMappings;
        this.blogFieldMappings = builder.blogFieldMappings;
        this.wikiFieldMappings = builder.wikiFieldMappings;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    public final String siteUrl() {
        return this.siteUrl;
    }

    public final String siteId() {
        return this.siteId;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final S3Path sslCertificateS3Path() {
        return this.sslCertificateS3Path;
    }

    public final Boolean crawlSystemFolders() {
        return this.crawlSystemFolders;
    }

    public final Boolean crawlComments() {
        return this.crawlComments;
    }

    public final List<AlfrescoEntity> entityFilter() {
        return EntityFilterCopier.copyStringToEnum(this.entityFilter);
    }

    public final boolean hasEntityFilter() {
        return this.entityFilter != null && !(this.entityFilter instanceof SdkAutoConstructList);
    }

    public final List<String> entityFilterAsStrings() {
        return this.entityFilter;
    }

    public final boolean hasDocumentLibraryFieldMappings() {
        return this.documentLibraryFieldMappings != null && !(this.documentLibraryFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> documentLibraryFieldMappings() {
        return this.documentLibraryFieldMappings;
    }

    public final boolean hasBlogFieldMappings() {
        return this.blogFieldMappings != null && !(this.blogFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> blogFieldMappings() {
        return this.blogFieldMappings;
    }

    public final boolean hasWikiFieldMappings() {
        return this.wikiFieldMappings != null && !(this.wikiFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> wikiFieldMappings() {
        return this.wikiFieldMappings;
    }

    public final boolean hasInclusionPatterns() {
        return this.inclusionPatterns != null && !(this.inclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionPatterns() {
        return this.inclusionPatterns;
    }

    public final boolean hasExclusionPatterns() {
        return this.exclusionPatterns != null && !(this.exclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionPatterns() {
        return this.exclusionPatterns;
    }

    public final DataSourceVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.siteUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.siteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslCertificateS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlSystemFolders());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlComments());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityFilter() ? this.entityFilterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentLibraryFieldMappings() ? this.documentLibraryFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlogFieldMappings() ? this.blogFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWikiFieldMappings() ? this.wikiFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionPatterns() ? this.inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionPatterns() ? this.exclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlfrescoConfiguration)) {
            return false;
        }
        AlfrescoConfiguration other = (AlfrescoConfiguration)obj;
        return Objects.equals(this.siteUrl(), other.siteUrl()) && Objects.equals(this.siteId(), other.siteId()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.sslCertificateS3Path(), other.sslCertificateS3Path()) && Objects.equals(this.crawlSystemFolders(), other.crawlSystemFolders()) && Objects.equals(this.crawlComments(), other.crawlComments()) && this.hasEntityFilter() == other.hasEntityFilter() && Objects.equals(this.entityFilterAsStrings(), other.entityFilterAsStrings()) && this.hasDocumentLibraryFieldMappings() == other.hasDocumentLibraryFieldMappings() && Objects.equals(this.documentLibraryFieldMappings(), other.documentLibraryFieldMappings()) && this.hasBlogFieldMappings() == other.hasBlogFieldMappings() && Objects.equals(this.blogFieldMappings(), other.blogFieldMappings()) && this.hasWikiFieldMappings() == other.hasWikiFieldMappings() && Objects.equals(this.wikiFieldMappings(), other.wikiFieldMappings()) && this.hasInclusionPatterns() == other.hasInclusionPatterns() && Objects.equals(this.inclusionPatterns(), other.inclusionPatterns()) && this.hasExclusionPatterns() == other.hasExclusionPatterns() && Objects.equals(this.exclusionPatterns(), other.exclusionPatterns()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AlfrescoConfiguration").add("SiteUrl", (Object)this.siteUrl()).add("SiteId", (Object)this.siteId()).add("SecretArn", (Object)this.secretArn()).add("SslCertificateS3Path", (Object)this.sslCertificateS3Path()).add("CrawlSystemFolders", (Object)this.crawlSystemFolders()).add("CrawlComments", (Object)this.crawlComments()).add("EntityFilter", this.hasEntityFilter() ? this.entityFilterAsStrings() : null).add("DocumentLibraryFieldMappings", this.hasDocumentLibraryFieldMappings() ? this.documentLibraryFieldMappings() : null).add("BlogFieldMappings", this.hasBlogFieldMappings() ? this.blogFieldMappings() : null).add("WikiFieldMappings", this.hasWikiFieldMappings() ? this.wikiFieldMappings() : null).add("InclusionPatterns", this.hasInclusionPatterns() ? this.inclusionPatterns() : null).add("ExclusionPatterns", this.hasExclusionPatterns() ? this.exclusionPatterns() : null).add("VpcConfiguration", (Object)this.vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SiteUrl": {
                return Optional.ofNullable(clazz.cast(this.siteUrl()));
            }
            case "SiteId": {
                return Optional.ofNullable(clazz.cast(this.siteId()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "SslCertificateS3Path": {
                return Optional.ofNullable(clazz.cast(this.sslCertificateS3Path()));
            }
            case "CrawlSystemFolders": {
                return Optional.ofNullable(clazz.cast(this.crawlSystemFolders()));
            }
            case "CrawlComments": {
                return Optional.ofNullable(clazz.cast(this.crawlComments()));
            }
            case "EntityFilter": {
                return Optional.ofNullable(clazz.cast(this.entityFilterAsStrings()));
            }
            case "DocumentLibraryFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.documentLibraryFieldMappings()));
            }
            case "BlogFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.blogFieldMappings()));
            }
            case "WikiFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.wikiFieldMappings()));
            }
            case "InclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.inclusionPatterns()));
            }
            case "ExclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.exclusionPatterns()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SiteUrl", SITE_URL_FIELD);
        map.put("SiteId", SITE_ID_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("SslCertificateS3Path", SSL_CERTIFICATE_S3_PATH_FIELD);
        map.put("CrawlSystemFolders", CRAWL_SYSTEM_FOLDERS_FIELD);
        map.put("CrawlComments", CRAWL_COMMENTS_FIELD);
        map.put("EntityFilter", ENTITY_FILTER_FIELD);
        map.put("DocumentLibraryFieldMappings", DOCUMENT_LIBRARY_FIELD_MAPPINGS_FIELD);
        map.put("BlogFieldMappings", BLOG_FIELD_MAPPINGS_FIELD);
        map.put("WikiFieldMappings", WIKI_FIELD_MAPPINGS_FIELD);
        map.put("InclusionPatterns", INCLUSION_PATTERNS_FIELD);
        map.put("ExclusionPatterns", EXCLUSION_PATTERNS_FIELD);
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlfrescoConfiguration, T> g) {
        return obj -> g.apply((AlfrescoConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String siteUrl;
        private String siteId;
        private String secretArn;
        private S3Path sslCertificateS3Path;
        private Boolean crawlSystemFolders;
        private Boolean crawlComments;
        private List<String> entityFilter = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> documentLibraryFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> blogFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> wikiFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private DataSourceVpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AlfrescoConfiguration model) {
            this.siteUrl(model.siteUrl);
            this.siteId(model.siteId);
            this.secretArn(model.secretArn);
            this.sslCertificateS3Path(model.sslCertificateS3Path);
            this.crawlSystemFolders(model.crawlSystemFolders);
            this.crawlComments(model.crawlComments);
            this.entityFilterWithStrings(model.entityFilter);
            this.documentLibraryFieldMappings(model.documentLibraryFieldMappings);
            this.blogFieldMappings(model.blogFieldMappings);
            this.wikiFieldMappings(model.wikiFieldMappings);
            this.inclusionPatterns(model.inclusionPatterns);
            this.exclusionPatterns(model.exclusionPatterns);
            this.vpcConfiguration(model.vpcConfiguration);
        }

        public final String getSiteUrl() {
            return this.siteUrl;
        }

        public final void setSiteUrl(String siteUrl) {
            this.siteUrl = siteUrl;
        }

        @Override
        public final Builder siteUrl(String siteUrl) {
            this.siteUrl = siteUrl;
            return this;
        }

        public final String getSiteId() {
            return this.siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final S3Path.Builder getSslCertificateS3Path() {
            return this.sslCertificateS3Path != null ? this.sslCertificateS3Path.toBuilder() : null;
        }

        public final void setSslCertificateS3Path(S3Path.BuilderImpl sslCertificateS3Path) {
            this.sslCertificateS3Path = sslCertificateS3Path != null ? sslCertificateS3Path.build() : null;
        }

        @Override
        public final Builder sslCertificateS3Path(S3Path sslCertificateS3Path) {
            this.sslCertificateS3Path = sslCertificateS3Path;
            return this;
        }

        public final Boolean getCrawlSystemFolders() {
            return this.crawlSystemFolders;
        }

        public final void setCrawlSystemFolders(Boolean crawlSystemFolders) {
            this.crawlSystemFolders = crawlSystemFolders;
        }

        @Override
        public final Builder crawlSystemFolders(Boolean crawlSystemFolders) {
            this.crawlSystemFolders = crawlSystemFolders;
            return this;
        }

        public final Boolean getCrawlComments() {
            return this.crawlComments;
        }

        public final void setCrawlComments(Boolean crawlComments) {
            this.crawlComments = crawlComments;
        }

        @Override
        public final Builder crawlComments(Boolean crawlComments) {
            this.crawlComments = crawlComments;
            return this;
        }

        public final Collection<String> getEntityFilter() {
            if (this.entityFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entityFilter;
        }

        public final void setEntityFilter(Collection<String> entityFilter) {
            this.entityFilter = EntityFilterCopier.copy(entityFilter);
        }

        @Override
        public final Builder entityFilterWithStrings(Collection<String> entityFilter) {
            this.entityFilter = EntityFilterCopier.copy(entityFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityFilterWithStrings(String ... entityFilter) {
            this.entityFilterWithStrings(Arrays.asList(entityFilter));
            return this;
        }

        @Override
        public final Builder entityFilter(Collection<AlfrescoEntity> entityFilter) {
            this.entityFilter = EntityFilterCopier.copyEnumToString(entityFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityFilter(AlfrescoEntity ... entityFilter) {
            this.entityFilter(Arrays.asList(entityFilter));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getDocumentLibraryFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.documentLibraryFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentLibraryFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> documentLibraryFieldMappings) {
            this.documentLibraryFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(documentLibraryFieldMappings);
        }

        @Override
        public final Builder documentLibraryFieldMappings(Collection<DataSourceToIndexFieldMapping> documentLibraryFieldMappings) {
            this.documentLibraryFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(documentLibraryFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentLibraryFieldMappings(DataSourceToIndexFieldMapping ... documentLibraryFieldMappings) {
            this.documentLibraryFieldMappings(Arrays.asList(documentLibraryFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentLibraryFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... documentLibraryFieldMappings) {
            this.documentLibraryFieldMappings(Stream.of(documentLibraryFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getBlogFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.blogFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlogFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> blogFieldMappings) {
            this.blogFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(blogFieldMappings);
        }

        @Override
        public final Builder blogFieldMappings(Collection<DataSourceToIndexFieldMapping> blogFieldMappings) {
            this.blogFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(blogFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blogFieldMappings(DataSourceToIndexFieldMapping ... blogFieldMappings) {
            this.blogFieldMappings(Arrays.asList(blogFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blogFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... blogFieldMappings) {
            this.blogFieldMappings(Stream.of(blogFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getWikiFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.wikiFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWikiFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> wikiFieldMappings) {
            this.wikiFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(wikiFieldMappings);
        }

        @Override
        public final Builder wikiFieldMappings(Collection<DataSourceToIndexFieldMapping> wikiFieldMappings) {
            this.wikiFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(wikiFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wikiFieldMappings(DataSourceToIndexFieldMapping ... wikiFieldMappings) {
            this.wikiFieldMappings(Arrays.asList(wikiFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wikiFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... wikiFieldMappings) {
            this.wikiFieldMappings(Stream.of(wikiFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getInclusionPatterns() {
            if (this.inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionPatterns;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String ... inclusionPatterns) {
            this.inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final Collection<String> getExclusionPatterns() {
            if (this.exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionPatterns;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String ... exclusionPatterns) {
            this.exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public AlfrescoConfiguration build() {
            return new AlfrescoConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlfrescoConfiguration> {
        public Builder siteUrl(String var1);

        public Builder siteId(String var1);

        public Builder secretArn(String var1);

        public Builder sslCertificateS3Path(S3Path var1);

        default public Builder sslCertificateS3Path(Consumer<S3Path.Builder> sslCertificateS3Path) {
            return this.sslCertificateS3Path((S3Path)((S3Path.Builder)S3Path.builder().applyMutation(sslCertificateS3Path)).build());
        }

        public Builder crawlSystemFolders(Boolean var1);

        public Builder crawlComments(Boolean var1);

        public Builder entityFilterWithStrings(Collection<String> var1);

        public Builder entityFilterWithStrings(String ... var1);

        public Builder entityFilter(Collection<AlfrescoEntity> var1);

        public Builder entityFilter(AlfrescoEntity ... var1);

        public Builder documentLibraryFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder documentLibraryFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder documentLibraryFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder blogFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder blogFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder blogFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder wikiFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder wikiFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder wikiFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder inclusionPatterns(Collection<String> var1);

        public Builder inclusionPatterns(String ... var1);

        public Builder exclusionPatterns(Collection<String> var1);

        public Builder exclusionPatterns(String ... var1);

        public Builder vpcConfiguration(DataSourceVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((DataSourceVpcConfiguration)((DataSourceVpcConfiguration.Builder)DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }
    }
}

