/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.FeaturedResultsSetIdListCopier;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteFeaturedResultsSetRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, BatchDeleteFeaturedResultsSetRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(BatchDeleteFeaturedResultsSetRequest.getter(BatchDeleteFeaturedResultsSetRequest::indexId)).setter(BatchDeleteFeaturedResultsSetRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<List<String>> FEATURED_RESULTS_SET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeaturedResultsSetIds").getter(BatchDeleteFeaturedResultsSetRequest.getter(BatchDeleteFeaturedResultsSetRequest::featuredResultsSetIds)).setter(BatchDeleteFeaturedResultsSetRequest.setter(Builder::featuredResultsSetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, FEATURED_RESULTS_SET_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IndexId", INDEX_ID_FIELD);
            this.put("FeaturedResultsSetIds", FEATURED_RESULTS_SET_IDS_FIELD);
        }
    });
    private final String indexId;
    private final List<String> featuredResultsSetIds;

    private BatchDeleteFeaturedResultsSetRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.featuredResultsSetIds = builder.featuredResultsSetIds;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final boolean hasFeaturedResultsSetIds() {
        return this.featuredResultsSetIds != null && !(this.featuredResultsSetIds instanceof SdkAutoConstructList);
    }

    public final List<String> featuredResultsSetIds() {
        return this.featuredResultsSetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeaturedResultsSetIds() ? this.featuredResultsSetIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteFeaturedResultsSetRequest)) {
            return false;
        }
        BatchDeleteFeaturedResultsSetRequest other = (BatchDeleteFeaturedResultsSetRequest)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && this.hasFeaturedResultsSetIds() == other.hasFeaturedResultsSetIds() && Objects.equals(this.featuredResultsSetIds(), other.featuredResultsSetIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteFeaturedResultsSetRequest").add("IndexId", (Object)this.indexId()).add("FeaturedResultsSetIds", this.hasFeaturedResultsSetIds() ? this.featuredResultsSetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "FeaturedResultsSetIds": {
                return Optional.ofNullable(clazz.cast(this.featuredResultsSetIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteFeaturedResultsSetRequest, T> g) {
        return obj -> g.apply((BatchDeleteFeaturedResultsSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String indexId;
        private List<String> featuredResultsSetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteFeaturedResultsSetRequest model) {
            super(model);
            this.indexId(model.indexId);
            this.featuredResultsSetIds(model.featuredResultsSetIds);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final Collection<String> getFeaturedResultsSetIds() {
            if (this.featuredResultsSetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.featuredResultsSetIds;
        }

        public final void setFeaturedResultsSetIds(Collection<String> featuredResultsSetIds) {
            this.featuredResultsSetIds = FeaturedResultsSetIdListCopier.copy(featuredResultsSetIds);
        }

        @Override
        public final Builder featuredResultsSetIds(Collection<String> featuredResultsSetIds) {
            this.featuredResultsSetIds = FeaturedResultsSetIdListCopier.copy(featuredResultsSetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredResultsSetIds(String ... featuredResultsSetIds) {
            this.featuredResultsSetIds(Arrays.asList(featuredResultsSetIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteFeaturedResultsSetRequest build() {
            return new BatchDeleteFeaturedResultsSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteFeaturedResultsSetRequest> {
        public Builder indexId(String var1);

        public Builder featuredResultsSetIds(Collection<String> var1);

        public Builder featuredResultsSetIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

