/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.AttributeFilter;
import software.amazon.awssdk.services.kendra.model.CollapseConfiguration;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeKeyListCopier;
import software.amazon.awssdk.services.kendra.model.DocumentRelevanceConfiguration;
import software.amazon.awssdk.services.kendra.model.DocumentRelevanceOverrideConfigurationListCopier;
import software.amazon.awssdk.services.kendra.model.Facet;
import software.amazon.awssdk.services.kendra.model.FacetListCopier;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.services.kendra.model.QueryResultType;
import software.amazon.awssdk.services.kendra.model.SortingConfiguration;
import software.amazon.awssdk.services.kendra.model.SortingConfigurationListCopier;
import software.amazon.awssdk.services.kendra.model.SpellCorrectionConfiguration;
import software.amazon.awssdk.services.kendra.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, QueryRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(QueryRequest.getter(QueryRequest::indexId)).setter(QueryRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryText").getter(QueryRequest.getter(QueryRequest::queryText)).setter(QueryRequest.setter(Builder::queryText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()}).build();
    private static final SdkField<AttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttributeFilter").getter(QueryRequest.getter(QueryRequest::attributeFilter)).setter(QueryRequest.setter(Builder::attributeFilter)).constructor(AttributeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilter").build()}).build();
    private static final SdkField<List<Facet>> FACETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Facets").getter(QueryRequest.getter(QueryRequest::facets)).setter(QueryRequest.setter(Builder::facets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Facets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Facet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REQUESTED_DOCUMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequestedDocumentAttributes").getter(QueryRequest.getter(QueryRequest::requestedDocumentAttributes)).setter(QueryRequest.setter(Builder::requestedDocumentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedDocumentAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> QUERY_RESULT_TYPE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryResultTypeFilter").getter(QueryRequest.getter(QueryRequest::queryResultTypeFilterAsString)).setter(QueryRequest.setter(Builder::queryResultTypeFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryResultTypeFilter").build()}).build();
    private static final SdkField<List<DocumentRelevanceConfiguration>> DOCUMENT_RELEVANCE_OVERRIDE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentRelevanceOverrideConfigurations").getter(QueryRequest.getter(QueryRequest::documentRelevanceOverrideConfigurations)).setter(QueryRequest.setter(Builder::documentRelevanceOverrideConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentRelevanceOverrideConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentRelevanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PAGE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageNumber").getter(QueryRequest.getter(QueryRequest::pageNumber)).setter(QueryRequest.setter(Builder::pageNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageNumber").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(QueryRequest.getter(QueryRequest::pageSize)).setter(QueryRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<SortingConfiguration> SORTING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortingConfiguration").getter(QueryRequest.getter(QueryRequest::sortingConfiguration)).setter(QueryRequest.setter(Builder::sortingConfiguration)).constructor(SortingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortingConfiguration").build()}).build();
    private static final SdkField<List<SortingConfiguration>> SORTING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SortingConfigurations").getter(QueryRequest.getter(QueryRequest::sortingConfigurations)).setter(QueryRequest.setter(Builder::sortingConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortingConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SortingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<UserContext> USER_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserContext").getter(QueryRequest.getter(QueryRequest::userContext)).setter(QueryRequest.setter(Builder::userContext)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContext").build()}).build();
    private static final SdkField<String> VISITOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VisitorId").getter(QueryRequest.getter(QueryRequest::visitorId)).setter(QueryRequest.setter(Builder::visitorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisitorId").build()}).build();
    private static final SdkField<SpellCorrectionConfiguration> SPELL_CORRECTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpellCorrectionConfiguration").getter(QueryRequest.getter(QueryRequest::spellCorrectionConfiguration)).setter(QueryRequest.setter(Builder::spellCorrectionConfiguration)).constructor(SpellCorrectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpellCorrectionConfiguration").build()}).build();
    private static final SdkField<CollapseConfiguration> COLLAPSE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CollapseConfiguration").getter(QueryRequest.getter(QueryRequest::collapseConfiguration)).setter(QueryRequest.setter(Builder::collapseConfiguration)).constructor(CollapseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollapseConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, QUERY_TEXT_FIELD, ATTRIBUTE_FILTER_FIELD, FACETS_FIELD, REQUESTED_DOCUMENT_ATTRIBUTES_FIELD, QUERY_RESULT_TYPE_FILTER_FIELD, DOCUMENT_RELEVANCE_OVERRIDE_CONFIGURATIONS_FIELD, PAGE_NUMBER_FIELD, PAGE_SIZE_FIELD, SORTING_CONFIGURATION_FIELD, SORTING_CONFIGURATIONS_FIELD, USER_CONTEXT_FIELD, VISITOR_ID_FIELD, SPELL_CORRECTION_CONFIGURATION_FIELD, COLLAPSE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IndexId", INDEX_ID_FIELD);
            this.put("QueryText", QUERY_TEXT_FIELD);
            this.put("AttributeFilter", ATTRIBUTE_FILTER_FIELD);
            this.put("Facets", FACETS_FIELD);
            this.put("RequestedDocumentAttributes", REQUESTED_DOCUMENT_ATTRIBUTES_FIELD);
            this.put("QueryResultTypeFilter", QUERY_RESULT_TYPE_FILTER_FIELD);
            this.put("DocumentRelevanceOverrideConfigurations", DOCUMENT_RELEVANCE_OVERRIDE_CONFIGURATIONS_FIELD);
            this.put("PageNumber", PAGE_NUMBER_FIELD);
            this.put("PageSize", PAGE_SIZE_FIELD);
            this.put("SortingConfiguration", SORTING_CONFIGURATION_FIELD);
            this.put("SortingConfigurations", SORTING_CONFIGURATIONS_FIELD);
            this.put("UserContext", USER_CONTEXT_FIELD);
            this.put("VisitorId", VISITOR_ID_FIELD);
            this.put("SpellCorrectionConfiguration", SPELL_CORRECTION_CONFIGURATION_FIELD);
            this.put("CollapseConfiguration", COLLAPSE_CONFIGURATION_FIELD);
        }
    });
    private final String indexId;
    private final String queryText;
    private final AttributeFilter attributeFilter;
    private final List<Facet> facets;
    private final List<String> requestedDocumentAttributes;
    private final String queryResultTypeFilter;
    private final List<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations;
    private final Integer pageNumber;
    private final Integer pageSize;
    private final SortingConfiguration sortingConfiguration;
    private final List<SortingConfiguration> sortingConfigurations;
    private final UserContext userContext;
    private final String visitorId;
    private final SpellCorrectionConfiguration spellCorrectionConfiguration;
    private final CollapseConfiguration collapseConfiguration;

    private QueryRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.queryText = builder.queryText;
        this.attributeFilter = builder.attributeFilter;
        this.facets = builder.facets;
        this.requestedDocumentAttributes = builder.requestedDocumentAttributes;
        this.queryResultTypeFilter = builder.queryResultTypeFilter;
        this.documentRelevanceOverrideConfigurations = builder.documentRelevanceOverrideConfigurations;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.sortingConfiguration = builder.sortingConfiguration;
        this.sortingConfigurations = builder.sortingConfigurations;
        this.userContext = builder.userContext;
        this.visitorId = builder.visitorId;
        this.spellCorrectionConfiguration = builder.spellCorrectionConfiguration;
        this.collapseConfiguration = builder.collapseConfiguration;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String queryText() {
        return this.queryText;
    }

    public final AttributeFilter attributeFilter() {
        return this.attributeFilter;
    }

    public final boolean hasFacets() {
        return this.facets != null && !(this.facets instanceof SdkAutoConstructList);
    }

    public final List<Facet> facets() {
        return this.facets;
    }

    public final boolean hasRequestedDocumentAttributes() {
        return this.requestedDocumentAttributes != null && !(this.requestedDocumentAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> requestedDocumentAttributes() {
        return this.requestedDocumentAttributes;
    }

    public final QueryResultType queryResultTypeFilter() {
        return QueryResultType.fromValue(this.queryResultTypeFilter);
    }

    public final String queryResultTypeFilterAsString() {
        return this.queryResultTypeFilter;
    }

    public final boolean hasDocumentRelevanceOverrideConfigurations() {
        return this.documentRelevanceOverrideConfigurations != null && !(this.documentRelevanceOverrideConfigurations instanceof SdkAutoConstructList);
    }

    public final List<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations() {
        return this.documentRelevanceOverrideConfigurations;
    }

    public final Integer pageNumber() {
        return this.pageNumber;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    public final SortingConfiguration sortingConfiguration() {
        return this.sortingConfiguration;
    }

    public final boolean hasSortingConfigurations() {
        return this.sortingConfigurations != null && !(this.sortingConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SortingConfiguration> sortingConfigurations() {
        return this.sortingConfigurations;
    }

    public final UserContext userContext() {
        return this.userContext;
    }

    public final String visitorId() {
        return this.visitorId;
    }

    public final SpellCorrectionConfiguration spellCorrectionConfiguration() {
        return this.spellCorrectionConfiguration;
    }

    public final CollapseConfiguration collapseConfiguration() {
        return this.collapseConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryText());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFacets() ? this.facets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestedDocumentAttributes() ? this.requestedDocumentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queryResultTypeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentRelevanceOverrideConfigurations() ? this.documentRelevanceOverrideConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pageNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSortingConfigurations() ? this.sortingConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.visitorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spellCorrectionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.collapseConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.queryText(), other.queryText()) && Objects.equals(this.attributeFilter(), other.attributeFilter()) && this.hasFacets() == other.hasFacets() && Objects.equals(this.facets(), other.facets()) && this.hasRequestedDocumentAttributes() == other.hasRequestedDocumentAttributes() && Objects.equals(this.requestedDocumentAttributes(), other.requestedDocumentAttributes()) && Objects.equals(this.queryResultTypeFilterAsString(), other.queryResultTypeFilterAsString()) && this.hasDocumentRelevanceOverrideConfigurations() == other.hasDocumentRelevanceOverrideConfigurations() && Objects.equals(this.documentRelevanceOverrideConfigurations(), other.documentRelevanceOverrideConfigurations()) && Objects.equals(this.pageNumber(), other.pageNumber()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.sortingConfiguration(), other.sortingConfiguration()) && this.hasSortingConfigurations() == other.hasSortingConfigurations() && Objects.equals(this.sortingConfigurations(), other.sortingConfigurations()) && Objects.equals(this.userContext(), other.userContext()) && Objects.equals(this.visitorId(), other.visitorId()) && Objects.equals(this.spellCorrectionConfiguration(), other.spellCorrectionConfiguration()) && Objects.equals(this.collapseConfiguration(), other.collapseConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"QueryRequest").add("IndexId", (Object)this.indexId()).add("QueryText", (Object)this.queryText()).add("AttributeFilter", (Object)this.attributeFilter()).add("Facets", this.hasFacets() ? this.facets() : null).add("RequestedDocumentAttributes", this.hasRequestedDocumentAttributes() ? this.requestedDocumentAttributes() : null).add("QueryResultTypeFilter", (Object)this.queryResultTypeFilterAsString()).add("DocumentRelevanceOverrideConfigurations", this.hasDocumentRelevanceOverrideConfigurations() ? this.documentRelevanceOverrideConfigurations() : null).add("PageNumber", (Object)this.pageNumber()).add("PageSize", (Object)this.pageSize()).add("SortingConfiguration", (Object)this.sortingConfiguration()).add("SortingConfigurations", this.hasSortingConfigurations() ? this.sortingConfigurations() : null).add("UserContext", (Object)this.userContext()).add("VisitorId", (Object)this.visitorId()).add("SpellCorrectionConfiguration", (Object)this.spellCorrectionConfiguration()).add("CollapseConfiguration", (Object)this.collapseConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "QueryText": {
                return Optional.ofNullable(clazz.cast(this.queryText()));
            }
            case "AttributeFilter": {
                return Optional.ofNullable(clazz.cast(this.attributeFilter()));
            }
            case "Facets": {
                return Optional.ofNullable(clazz.cast(this.facets()));
            }
            case "RequestedDocumentAttributes": {
                return Optional.ofNullable(clazz.cast(this.requestedDocumentAttributes()));
            }
            case "QueryResultTypeFilter": {
                return Optional.ofNullable(clazz.cast(this.queryResultTypeFilterAsString()));
            }
            case "DocumentRelevanceOverrideConfigurations": {
                return Optional.ofNullable(clazz.cast(this.documentRelevanceOverrideConfigurations()));
            }
            case "PageNumber": {
                return Optional.ofNullable(clazz.cast(this.pageNumber()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "SortingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sortingConfiguration()));
            }
            case "SortingConfigurations": {
                return Optional.ofNullable(clazz.cast(this.sortingConfigurations()));
            }
            case "UserContext": {
                return Optional.ofNullable(clazz.cast(this.userContext()));
            }
            case "VisitorId": {
                return Optional.ofNullable(clazz.cast(this.visitorId()));
            }
            case "SpellCorrectionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.spellCorrectionConfiguration()));
            }
            case "CollapseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.collapseConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QueryRequest, T> g) {
        return obj -> g.apply((QueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String indexId;
        private String queryText;
        private AttributeFilter attributeFilter;
        private List<Facet> facets = DefaultSdkAutoConstructList.getInstance();
        private List<String> requestedDocumentAttributes = DefaultSdkAutoConstructList.getInstance();
        private String queryResultTypeFilter;
        private List<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Integer pageNumber;
        private Integer pageSize;
        private SortingConfiguration sortingConfiguration;
        private List<SortingConfiguration> sortingConfigurations = DefaultSdkAutoConstructList.getInstance();
        private UserContext userContext;
        private String visitorId;
        private SpellCorrectionConfiguration spellCorrectionConfiguration;
        private CollapseConfiguration collapseConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRequest model) {
            super(model);
            this.indexId(model.indexId);
            this.queryText(model.queryText);
            this.attributeFilter(model.attributeFilter);
            this.facets(model.facets);
            this.requestedDocumentAttributes(model.requestedDocumentAttributes);
            this.queryResultTypeFilter(model.queryResultTypeFilter);
            this.documentRelevanceOverrideConfigurations(model.documentRelevanceOverrideConfigurations);
            this.pageNumber(model.pageNumber);
            this.pageSize(model.pageSize);
            this.sortingConfiguration(model.sortingConfiguration);
            this.sortingConfigurations(model.sortingConfigurations);
            this.userContext(model.userContext);
            this.visitorId(model.visitorId);
            this.spellCorrectionConfiguration(model.spellCorrectionConfiguration);
            this.collapseConfiguration(model.collapseConfiguration);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getQueryText() {
            return this.queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final AttributeFilter.Builder getAttributeFilter() {
            return this.attributeFilter != null ? this.attributeFilter.toBuilder() : null;
        }

        public final void setAttributeFilter(AttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        @Override
        public final Builder attributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        public final List<Facet.Builder> getFacets() {
            List<Facet.Builder> result = FacetListCopier.copyToBuilder(this.facets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFacets(Collection<Facet.BuilderImpl> facets) {
            this.facets = FacetListCopier.copyFromBuilder(facets);
        }

        @Override
        public final Builder facets(Collection<Facet> facets) {
            this.facets = FacetListCopier.copy(facets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facets(Facet ... facets) {
            this.facets(Arrays.asList(facets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facets(Consumer<Facet.Builder> ... facets) {
            this.facets(Stream.of(facets).map(c -> (Facet)((Facet.Builder)Facet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRequestedDocumentAttributes() {
            if (this.requestedDocumentAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requestedDocumentAttributes;
        }

        public final void setRequestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
            this.requestedDocumentAttributes = DocumentAttributeKeyListCopier.copy(requestedDocumentAttributes);
        }

        @Override
        public final Builder requestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
            this.requestedDocumentAttributes = DocumentAttributeKeyListCopier.copy(requestedDocumentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedDocumentAttributes(String ... requestedDocumentAttributes) {
            this.requestedDocumentAttributes(Arrays.asList(requestedDocumentAttributes));
            return this;
        }

        public final String getQueryResultTypeFilter() {
            return this.queryResultTypeFilter;
        }

        public final void setQueryResultTypeFilter(String queryResultTypeFilter) {
            this.queryResultTypeFilter = queryResultTypeFilter;
        }

        @Override
        public final Builder queryResultTypeFilter(String queryResultTypeFilter) {
            this.queryResultTypeFilter = queryResultTypeFilter;
            return this;
        }

        @Override
        public final Builder queryResultTypeFilter(QueryResultType queryResultTypeFilter) {
            this.queryResultTypeFilter(queryResultTypeFilter == null ? null : queryResultTypeFilter.toString());
            return this;
        }

        public final List<DocumentRelevanceConfiguration.Builder> getDocumentRelevanceOverrideConfigurations() {
            List<DocumentRelevanceConfiguration.Builder> result = DocumentRelevanceOverrideConfigurationListCopier.copyToBuilder(this.documentRelevanceOverrideConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentRelevanceOverrideConfigurations(Collection<DocumentRelevanceConfiguration.BuilderImpl> documentRelevanceOverrideConfigurations) {
            this.documentRelevanceOverrideConfigurations = DocumentRelevanceOverrideConfigurationListCopier.copyFromBuilder(documentRelevanceOverrideConfigurations);
        }

        @Override
        public final Builder documentRelevanceOverrideConfigurations(Collection<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations) {
            this.documentRelevanceOverrideConfigurations = DocumentRelevanceOverrideConfigurationListCopier.copy(documentRelevanceOverrideConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentRelevanceOverrideConfigurations(DocumentRelevanceConfiguration ... documentRelevanceOverrideConfigurations) {
            this.documentRelevanceOverrideConfigurations(Arrays.asList(documentRelevanceOverrideConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentRelevanceOverrideConfigurations(Consumer<DocumentRelevanceConfiguration.Builder> ... documentRelevanceOverrideConfigurations) {
            this.documentRelevanceOverrideConfigurations(Stream.of(documentRelevanceOverrideConfigurations).map(c -> (DocumentRelevanceConfiguration)((DocumentRelevanceConfiguration.Builder)DocumentRelevanceConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getPageNumber() {
            return this.pageNumber;
        }

        public final void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        @Override
        public final Builder pageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final SortingConfiguration.Builder getSortingConfiguration() {
            return this.sortingConfiguration != null ? this.sortingConfiguration.toBuilder() : null;
        }

        public final void setSortingConfiguration(SortingConfiguration.BuilderImpl sortingConfiguration) {
            this.sortingConfiguration = sortingConfiguration != null ? sortingConfiguration.build() : null;
        }

        @Override
        public final Builder sortingConfiguration(SortingConfiguration sortingConfiguration) {
            this.sortingConfiguration = sortingConfiguration;
            return this;
        }

        public final List<SortingConfiguration.Builder> getSortingConfigurations() {
            List<SortingConfiguration.Builder> result = SortingConfigurationListCopier.copyToBuilder(this.sortingConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortingConfigurations(Collection<SortingConfiguration.BuilderImpl> sortingConfigurations) {
            this.sortingConfigurations = SortingConfigurationListCopier.copyFromBuilder(sortingConfigurations);
        }

        @Override
        public final Builder sortingConfigurations(Collection<SortingConfiguration> sortingConfigurations) {
            this.sortingConfigurations = SortingConfigurationListCopier.copy(sortingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortingConfigurations(SortingConfiguration ... sortingConfigurations) {
            this.sortingConfigurations(Arrays.asList(sortingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortingConfigurations(Consumer<SortingConfiguration.Builder> ... sortingConfigurations) {
            this.sortingConfigurations(Stream.of(sortingConfigurations).map(c -> (SortingConfiguration)((SortingConfiguration.Builder)SortingConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final UserContext.Builder getUserContext() {
            return this.userContext != null ? this.userContext.toBuilder() : null;
        }

        public final void setUserContext(UserContext.BuilderImpl userContext) {
            this.userContext = userContext != null ? userContext.build() : null;
        }

        @Override
        public final Builder userContext(UserContext userContext) {
            this.userContext = userContext;
            return this;
        }

        public final String getVisitorId() {
            return this.visitorId;
        }

        public final void setVisitorId(String visitorId) {
            this.visitorId = visitorId;
        }

        @Override
        public final Builder visitorId(String visitorId) {
            this.visitorId = visitorId;
            return this;
        }

        public final SpellCorrectionConfiguration.Builder getSpellCorrectionConfiguration() {
            return this.spellCorrectionConfiguration != null ? this.spellCorrectionConfiguration.toBuilder() : null;
        }

        public final void setSpellCorrectionConfiguration(SpellCorrectionConfiguration.BuilderImpl spellCorrectionConfiguration) {
            this.spellCorrectionConfiguration = spellCorrectionConfiguration != null ? spellCorrectionConfiguration.build() : null;
        }

        @Override
        public final Builder spellCorrectionConfiguration(SpellCorrectionConfiguration spellCorrectionConfiguration) {
            this.spellCorrectionConfiguration = spellCorrectionConfiguration;
            return this;
        }

        public final CollapseConfiguration.Builder getCollapseConfiguration() {
            return this.collapseConfiguration != null ? this.collapseConfiguration.toBuilder() : null;
        }

        public final void setCollapseConfiguration(CollapseConfiguration.BuilderImpl collapseConfiguration) {
            this.collapseConfiguration = collapseConfiguration != null ? collapseConfiguration.build() : null;
        }

        @Override
        public final Builder collapseConfiguration(CollapseConfiguration collapseConfiguration) {
            this.collapseConfiguration = collapseConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryRequest build() {
            return new QueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryRequest> {
        public Builder indexId(String var1);

        public Builder queryText(String var1);

        public Builder attributeFilter(AttributeFilter var1);

        default public Builder attributeFilter(Consumer<AttributeFilter.Builder> attributeFilter) {
            return this.attributeFilter((AttributeFilter)((AttributeFilter.Builder)AttributeFilter.builder().applyMutation(attributeFilter)).build());
        }

        public Builder facets(Collection<Facet> var1);

        public Builder facets(Facet ... var1);

        public Builder facets(Consumer<Facet.Builder> ... var1);

        public Builder requestedDocumentAttributes(Collection<String> var1);

        public Builder requestedDocumentAttributes(String ... var1);

        public Builder queryResultTypeFilter(String var1);

        public Builder queryResultTypeFilter(QueryResultType var1);

        public Builder documentRelevanceOverrideConfigurations(Collection<DocumentRelevanceConfiguration> var1);

        public Builder documentRelevanceOverrideConfigurations(DocumentRelevanceConfiguration ... var1);

        public Builder documentRelevanceOverrideConfigurations(Consumer<DocumentRelevanceConfiguration.Builder> ... var1);

        public Builder pageNumber(Integer var1);

        public Builder pageSize(Integer var1);

        public Builder sortingConfiguration(SortingConfiguration var1);

        default public Builder sortingConfiguration(Consumer<SortingConfiguration.Builder> sortingConfiguration) {
            return this.sortingConfiguration((SortingConfiguration)((SortingConfiguration.Builder)SortingConfiguration.builder().applyMutation(sortingConfiguration)).build());
        }

        public Builder sortingConfigurations(Collection<SortingConfiguration> var1);

        public Builder sortingConfigurations(SortingConfiguration ... var1);

        public Builder sortingConfigurations(Consumer<SortingConfiguration.Builder> ... var1);

        public Builder userContext(UserContext var1);

        default public Builder userContext(Consumer<UserContext.Builder> userContext) {
            return this.userContext((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(userContext)).build());
        }

        public Builder visitorId(String var1);

        public Builder spellCorrectionConfiguration(SpellCorrectionConfiguration var1);

        default public Builder spellCorrectionConfiguration(Consumer<SpellCorrectionConfiguration.Builder> spellCorrectionConfiguration) {
            return this.spellCorrectionConfiguration((SpellCorrectionConfiguration)((SpellCorrectionConfiguration.Builder)SpellCorrectionConfiguration.builder().applyMutation(spellCorrectionConfiguration)).build());
        }

        public Builder collapseConfiguration(CollapseConfiguration var1);

        default public Builder collapseConfiguration(Consumer<CollapseConfiguration.Builder> collapseConfiguration) {
            return this.collapseConfiguration((CollapseConfiguration)((CollapseConfiguration.Builder)CollapseConfiguration.builder().applyMutation(collapseConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

